@inject('layoutHelper', 'JeroenNoten\LaravelAdminLte\Helpers\LayoutHelper')

<nav class="main-header navbar
    {{ config('adminlte.classes_topnav_nav', 'navbar-expand') }}
    {{ config('adminlte.classes_topnav', 'navbar-white navbar-light') }}">

    {{-- Navbar left links --}}
    <ul class="navbar-nav">
        {{-- Left sidebar toggler link --}}
        @include('adminlte::partials.navbar.menu-item-left-sidebar-toggler')

        {{-- Configured left links --}}
        @each('adminlte::partials.navbar.menu-item', $adminlte->menu('navbar-left'), 'item')

        {{-- Custom left links --}}
        @yield('content_top_nav_left')
    </ul>

    {{-- Navbar right links --}}
    <ul class="navbar-nav ml-auto">
        {{-- Icono de modo claro/oscuro --}}
        <li class="nav-item">
            <a href="#" class="nav-link" id="theme-toggle" data-toggle="tooltip" title="Cambiar tema">
                <i class="fas fa-moon" id="dark-icon"></i>
                <i class="fas fa-sun" id="light-icon" style="display: none;"></i>
            </a>
        </li>

        {{-- Custom right links --}}
        @yield('content_top_nav_right')

        {{-- Configured right links --}}
        @each('adminlte::partials.navbar.menu-item', $adminlte->menu('navbar-right'), 'item')

        {{-- User menu link --}}
        @if(Auth::user())
            @if(config('adminlte.usermenu_enabled'))
                @include('adminlte::partials.navbar.menu-item-dropdown-user-menu')
            @else
                @include('adminlte::partials.navbar.menu-item-logout-link')
            @endif
        @endif

        {{-- Right sidebar toggler link --}}
        @if($layoutHelper->isRightSidebarEnabled())
            @include('adminlte::partials.navbar.menu-item-right-sidebar-toggler')
        @endif
    </ul>
</nav>

<style>
    /* Estilos para el icono de tema */
    #theme-toggle {
        font-size: 1.2rem;
        padding: 0.5rem;
    }
    
    #light-icon {
        color: #f39c12;
    }
    
    #dark-icon {
        color: #6c757d;
    }
    
    /* Estilos para modo oscuro */
    .dark-mode {
        background-color: #343a40;
        color: #f8f9fa;
    }
    
    .dark-mode .main-header {
        background-color: #343a40 !important;
        border-bottom: 1px solid #454d55;
    }
    
    .dark-mode .navbar-light .navbar-nav .nav-link {
        color: rgba(255, 255, 255, 0.8);
    }
    
    .dark-mode .navbar-light .navbar-nav .nav-link:hover {
        color: rgba(255, 255, 255, 1);
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const themeToggle = document.getElementById('theme-toggle');
        const body = document.body;
        const darkIcon = document.getElementById('dark-icon');
        const lightIcon = document.getElementById('light-icon');
        
        // Verificar preferencia guardada
        if (localStorage.getItem('theme') === 'dark') {
            body.classList.add('dark-mode');
            darkIcon.style.display = 'none';
            lightIcon.style.display = 'inline';
        } else {
            darkIcon.style.display = 'inline';
            lightIcon.style.display = 'none';
        }
        
        // Escuchar clic en el icono
        themeToggle.addEventListener('click', function(e) {
            e.preventDefault();
            
            if (body.classList.contains('dark-mode')) {
                body.classList.remove('dark-mode');
                localStorage.setItem('theme', 'light');
                darkIcon.style.display = 'inline';
                lightIcon.style.display = 'none';
            } else {
                body.classList.add('dark-mode');
                localStorage.setItem('theme', 'dark');
                darkIcon.style.display = 'none';
                lightIcon.style.display = 'inline';
            }
        });

        // Detectar preferencia del sistema
        const prefersDarkScheme = window.matchMedia('(prefers-color-scheme: dark)');
        
        if (prefersDarkScheme.matches && !localStorage.getItem('theme')) {
            body.classList.add('dark-mode');
            darkIcon.style.display = 'none';
            lightIcon.style.display = 'inline';
        }
        
        prefersDarkScheme.addListener(e => {
            if (!localStorage.getItem('theme')) {
                if (e.matches) {
                    body.classList.add('dark-mode');
                    darkIcon.style.display = 'none';
                    lightIcon.style.display = 'inline';
                } else {
                    body.classList.remove('dark-mode');
                    darkIcon.style.display = 'inline';
                    lightIcon.style.display = 'none';
                }
            }
        });
    });
</script>