<?php $__empty_1 = true; $__currentLoopData = $peliculas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pelicula): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <tr>
        <td><?php echo e($pelicula->id); ?></td>
        <td>
            <a href="<?php echo e(route('peliculas.show', $pelicula)); ?>" class="text-dark font-weight-bold">
                <?php echo e($pelicula->titulo); ?>

            </a>
        </td>
        <td><?php echo e(floor($pelicula->duracion / 60)); ?>h <?php echo e($pelicula->duracion % 60); ?>min</td>
        <td>
            <span class="badge bg-secondary"><?php echo e($pelicula->formato); ?></span>
        </td>
        <td>
            <?php if($pelicula->categoria): ?>
                <span class="badge" style="background-color: <?php echo e($pelicula->categoria->color ?? '#6c757d'); ?>; color: white;">
                    <?php echo e($pelicula->categoria->nombre); ?>

                </span>
            <?php else: ?>
                <span class="badge bg-dark">Sin categoría</span>
            <?php endif; ?>
        </td>
        <td>
            <span class="badge <?php echo e($pelicula->estado == 'disponible' ? 'bg-success' : 'bg-danger'); ?>">
                <?php echo e(ucfirst($pelicula->estado)); ?>

            </span>
        </td>
        <td>
            <div class="d-flex justify-content-center">
                <a href="<?php echo e(route('peliculas.show', $pelicula)); ?>" class="btn btn-sm btn-info mx-1" title="Ver">
                    <i class="fas fa-eye"></i>
                </a>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('editar peliculas')): ?>
                <a href="<?php echo e(route('peliculas.edit', $pelicula)); ?>" class="btn btn-sm btn-warning mx-1" title="Editar">
                    <i class="fas fa-edit"></i>
                </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('eliminar peliculas')): ?>
                <form action="<?php echo e(route('peliculas.destroy', $pelicula)); ?>" method="POST" class="d-inline delete-form">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-sm btn-danger mx-1" title="Eliminar">
                        <i class="fas fa-trash-alt"></i>
                    </button>
                </form>
                <?php endif; ?>
            </div>
        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <tr>
        <td colspan="7" class="text-center py-4">
            <i class="fas fa-film fa-3x text-muted mb-3"></i>
            <h5 class="text-muted">No se encontraron películas</h5>
            <button onclick="location.reload()" class="btn btn-sm btn-primary mt-2">
                <i class="fas fa-undo mr-1"></i> Limpiar filtros
            </button>
        </td>
    </tr>
<?php endif; ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/peliculas/partials/movies_table_rows.blade.php ENDPATH**/ ?>