

<?php $__env->startSection('title', 'Editar Sala'); ?>

<head>
    <link rel="icon" href="<?php echo e(asset('icons/sala.png')); ?>" type="image/x-icon">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    <style>
        .card-form {
            border-radius: 15px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            border: none;
        }
        .card-header {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            color: white;
            border-radius: 15px 15px 0 0 !important;
            padding: 1.5rem;
        }
        .form-label {
            font-weight: 600;
            color: #5a5c69;
        }
        .form-control {
            border-radius: 10px;
            padding: 12px 15px;
            border: 1px solid #d1d3e2;
        }
        .form-control:focus {
            border-color: #bac8f3;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }
        .btn-success {
            background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
            border: none;
            padding: 12px 30px;
            font-weight: 600;
        }
        .btn-secondary {
            background: linear-gradient(135deg, #858796 0%, #60616f 100%);
            border: none;
            padding: 12px 30px;
            font-weight: 600;
        }
        .btn-lg {
            border-radius: 50px;
            transition: all 0.3s;
        }
        .btn-lg:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }
        select.form-control {
            appearance: none;
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
            background-repeat: no-repeat;
            background-position: right 12px center;
            background-size: 16px 12px;
        }
    </style>
</head>

<?php $__env->startSection('content_header'); ?>
    <h1 class="text-center"><i class="bi bi-easel2 me-2"></i> Editar Sala</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card card-form">
                <div class="card-header">
                    <h3 class="card-title mb-0">Información de la Sala</h3>
                </div>
                <div class="card-body p-4">
                    <form action="<?php echo e(route('salas.update', $sala)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <div class="mb-4">
                            <label for="nombre" class="form-label">
                                <i class="bi bi-tag-fill me-2"></i>Nombre de la Sala
                            </label>
                            <input type="text" name="nombre" class="form-control" 
                                   value="<?php echo e($sala->nombre); ?>" required
                                   placeholder="Ej: Sala 1, Sala VIP A">
                        </div>
                        
                        <div class="mb-4">
                            <label for="capacidad" class="form-label">
                                <i class="bi bi-people-fill me-2"></i>Capacidad
                            </label>
                            <input type="number" name="capacidad" class="form-control" 
                                   min="1" value="<?php echo e($sala->capacidad); ?>" required
                                   placeholder="Número de asientos">
                        </div>

                        <div class="mb-4">
                            <label for="estado" class="form-label">
                                <i class="bi bi-info-circle-fill me-2"></i>Estado
                            </label>
                            <select name="estado" id="estado" class="form-control">
                                <option value="disponible" <?php echo e($sala->estado == 'disponible' ? 'selected' : ''); ?>>
                                    <i class="bi bi-check-circle"></i> Disponible
                                </option>
                                <option value="ocupada" <?php echo e($sala->estado == 'ocupada' ? 'selected' : ''); ?>>
                                    <i class="bi bi-x-circle"></i> Ocupada
                                </option>
                                <option value="mantenimiento" <?php echo e($sala->estado == 'mantenimiento' ? 'selected' : ''); ?>>
                                    <i class="bi bi-tools"></i> En Mantenimiento
                                </option>
                            </select>
                        </div>

                        <div class="mb-4">
                            <label for="tipo" class="form-label">
                                <i class="bi bi-star-fill me-2"></i>Tipo de Sala
                            </label>
                            <select name="tipo" class="form-control" required>
                                <option value="Normal" <?php echo e($sala->tipo == 'Normal' ? 'selected' : ''); ?>>
                                    Normal
                                </option>
                                <option value="VIP" <?php echo e($sala->tipo == 'VIP' ? 'selected' : ''); ?>>
                                    VIP
                                </option>
                            </select>
                        </div>

                        <div class="d-flex justify-content-between mt-5">
                            <a href="<?php echo e(route('salas.index')); ?>" class="btn btn-lg btn-secondary shadow">
                                <i class="bi bi-arrow-left me-2"></i> Cancelar
                            </a>
                            <button type="submit" class="btn btn-lg btn-success shadow">
                                <i class="bi bi-check-circle me-2"></i> Actualizar
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/salas/edit.blade.php ENDPATH**/ ?>