

<?php $__env->startSection('title', 'Punto de Venta'); ?>

<?php $__env->startSection('css'); ?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<style>
    :root {
        --primary-color: #3498db;
        --secondary-color: #2ecc71;
        --danger-color: #e74c3c;
        --light-bg: #f8f9fa;
        --card-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        --transition: all 0.3s ease;
    }
    
    body {
        background-color: #f5f7fa;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    
    .pos-container {
        padding: 20px;
    }
    
    .card-main {
        border: none;
        border-radius: 12px;
        box-shadow: var(--card-shadow);
        transition: var(--transition);
        overflow: hidden;
    }
    
    .card-main:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
    }
    
    .card-header-custom {
        background-color: white;
        border-bottom: 2px solid var(--light-bg);
        padding: 15px 20px;
    }
    
    .title-section {
        color: var(--primary-color);
        font-weight: 600;
        margin-bottom: 0;
    }
    
    /* Productos */
    .products-container {
        max-height: 70vh;
        overflow-y: auto;
        padding-right: 10px;
    }

    .products-container::-webkit-scrollbar {
        width: 8px;
    }

    .products-container::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 10px;
    }

    .products-container::-webkit-scrollbar-thumb {
        background: #c1c1c1;
        border-radius: 10px;
    }

    .products-container::-webkit-scrollbar-thumb:hover {
        background: #a8a8a8;
    }

    .product-card {
        background: white;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: var(--card-shadow);
        transition: var(--transition);
        height: 100%;
    }
    
    .product-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 12px rgba(0, 0, 0, 0.1);
    }
    
    .product-img {
        height: 140px;
        object-fit: cover;
        width: 100%;
        border-bottom: 1px solid #eee;
    }
    
    .product-title {
        font-size: 1rem;
        font-weight: 600;
        color: #333;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .product-price {
        color: var(--secondary-color);
        font-weight: bold;
        font-size: 1rem;
    }
    
    .product-stock {
        font-size: 0.85rem;
        color: #666;
    }
    
    .btn-add-cart {
        background-color: var(--secondary-color);
        border: none;
        border-radius: 20px;
        padding: 8px 15px;
        font-weight: 500;
        transition: var(--transition);
    }
    
    .btn-add-cart:hover {
        background-color: #27ae60;
        transform: translateY(-2px);
    }
    
    /* Carrito */
    .cart-item {
        background: white;
        border-left: 4px solid var(--secondary-color);
        margin-bottom: 10px;
        border-radius: 8px;
        padding: 12px 15px;
        transition: var(--transition);
    }
    
    .cart-item:hover {
        background-color: #f8f9fa;
    }
    
    .total-display {
        background-color: #f8f9fa;
        padding: 15px;
        border-radius: 10px;
        font-size: 1.2rem;
        font-weight: 600;
    }
    
    /* Pago */
    .payment-section {
        background-color: white;
        border-radius: 10px;
        padding: 20px;
        box-shadow: var(--card-shadow);
    }
    
    .input-payment {
        border-radius: 8px;
        padding: 10px 15px;
        border: 1px solid #ddd;
    }
    
    /* Botones */
    .btn-checkout {
        background-color: var(--secondary-color);
        border: none;
        padding: 12px;
        font-size: 1.1rem;
        font-weight: 600;
        border-radius: 10px;
        transition: var(--transition);
    }
    
    .btn-checkout:hover {
        background-color: #27ae60;
        transform: translateY(-2px);
    }
    
    /* Búsqueda */
    .search-box {
        position: relative;
        margin-bottom: 20px;
    }
    
    .search-input {
        padding-left: 40px;
        border-radius: 20px;
        border: 1px solid #ddd;
        height: 45px;
    }
    
    .search-icon {
        position: absolute;
        top: 12px;
        left: 15px;
        color: #7f8c8d;
    }
    
    /* Select2 personalizado */
    .select2-container--default .select2-selection--single {
        height: 45px;
        border-radius: 8px;
        border: 1px solid #ddd;
        padding: 8px;
    }
    
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 43px;
    }
    
    /* Responsive */
    @media (max-width: 768px) {
        .pos-container {
            padding: 10px;
        }
        
        .product-img {
            height: 120px;
        }

        .products-container {
            max-height: 50vh;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="pos-container">
    <div class="row">
        <!-- Columna izquierda: Productos -->
        <div class="col-lg-8 mb-4">
            <div class="card-main">
                <div class="card-header-custom">
                    <h2 class="title-section"><i class="fas fa-cash-register mr-2"></i>Punto de Venta</h2>
                </div>
                <div class="card-body">
                    <!-- Barra de búsqueda -->
                    <div class="search-box">
                        <i class="fas fa-search search-icon"></i>
                        <input type="text" id="buscarProducto" class="form-control search-input" placeholder="Buscar producto por nombre...">
                    </div>
                    
                    <!-- Lista de productos con scroll -->
                    <div class="products-container">
                        <div class="row">
                            <?php $__currentLoopData = $productos->sortByDesc('stock'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-4 col-sm-6 mb-4">
                                <div class="product-card">
                                    <img src="<?php echo e(asset('storage/' . $producto->imagen)); ?>" class="product-img" alt="<?php echo e($producto->nombre); ?>">
                                    <div class="card-body">
                                        <h5 class="product-title"><?php echo e($producto->nombre); ?></h5>
                                        <p class="product-price mb-1">S/ <?php echo e(number_format($producto->precio, 2)); ?></p>
                                        <p class="product-stock mb-3">
                                            <span class="badge <?php echo e($producto->stock > 0 ? 'bg-success' : 'bg-danger'); ?>">
                                                <?php echo e($producto->stock > 0 ? 'Stock: ' . $producto->stock : 'Agotado'); ?>

                                            </span>
                                        </p>
                                        <button type="button" class="btn btn-add-cart w-100" 
                                            data-id="<?php echo e($producto->id); ?>" 
                                            data-nombre="<?php echo e($producto->nombre); ?>" 
                                            data-precio="<?php echo e($producto->precio); ?>" 
                                            data-stock="<?php echo e($producto->stock); ?>"
                                            <?php echo e($producto->stock <= 0 ? 'disabled' : ''); ?>

                                            onclick="agregarAlCarrito(this)">
                                            <i class="fas fa-cart-plus mr-2"></i>Agregar
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Columna derecha: Carrito y Pago -->
        <div class="col-lg-4">
            <!-- Carrito de compras -->
            <div class="card-main mb-4">
                <div class="card-header-custom">
                    <h3 class="title-section"><i class="fas fa-shopping-cart mr-2 text-success"></i>Carrito de Compra</h3>
                </div>
                <div class="card-body">
                    <div id="carrito" class="mb-3">
                        <!-- Los productos agregados aparecerán aquí -->
                        <div class="text-muted text-center py-3" id="empty-cart-message">
                            <i class="fas fa-shopping-cart fa-2x mb-2"></i>
                            <p>Tu carrito está vacío</p>
                        </div>
                    </div>
                    
                    <div class="total-display d-flex justify-content-between align-items-center">
                        <span class="font-weight-bold">Total:</span>
                        <span class="text-primary font-weight-bold">S/ <span id="total_venta">0.00</span></span>
                    </div>
                </div>
            </div>
            
            <!-- Sección de Pago -->
            <div class="card-main mb-4">
                <div class="card-header-custom">
                    <h3 class="title-section"><i class="fas fa-money-bill-wave mr-2 text-info"></i>Información de Pago</h3>
                </div>
                <div class="card-body payment-section">
                    <div class="form-group">
                        <label for="monto_pagado" class="font-weight-bold">Monto Recibido</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text bg-light">S/</span>
                            </div>
                            <input type="number" id="monto_pagado" class="form-control input-payment" min="0" step="0.01" onchange="calcularVuelto()">
                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <span class="font-weight-bold">Vuelto:</span>
                        <span class="text-success font-weight-bold">S/ <span id="vuelto">0.00</span></span>
                    </div>
                </div>
            </div>
            
            <!-- Selección de cliente -->
            <div class="card-main mb-4">
                <div class="card-header-custom">
                    <h3 class="title-section"><i class="fas fa-user mr-2 text-primary"></i>Datos del Cliente</h3>
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <label for="alquiler_id" class="font-weight-bold">Seleccionar Cliente</label>
                        <select name="alquiler_id" id="alquiler_id" class="form-control select2" required>
                            <option value="">-- Selecciona un cliente --</option>
                            <?php $__currentLoopData = $alquileres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alquiler): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($alquiler->id); ?>"><?php echo e($alquiler->cliente); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
            
            <!-- Botón de confirmación -->
            <button id="realizar_venta" class="btn btn-checkout w-100" disabled>
                <i class="fas fa-check-circle mr-2"></i>Confirmar Venta
            </button>
        </div>
    </div>
</div>

<!-- jQuery y Select2 -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

<script>
    // Inicializar Select2
    $(document).ready(function() {
        $('.select2').select2({
            placeholder: "Selecciona un cliente",
            allowClear: true
        });
    });

    // Resto de tu código JavaScript permanece igual
    document.getElementById('buscarProducto').addEventListener('input', function() {
        let filtro = this.value.toLowerCase();
        let productos = document.querySelectorAll('.col-md-4.col-sm-6.mb-4');
        
        productos.forEach(function(producto) {
            let nombre = producto.querySelector('.product-title').textContent.toLowerCase();
            producto.style.display = nombre.includes(filtro) ? 'block' : 'none';
        });
    });

    // Variables para gestionar el carrito
    let productosVenta = [];
    let totalVenta = 0;

    function actualizarTotal() {
        totalVenta = productosVenta.reduce((sum, p) => sum + p.subtotal, 0);
        document.getElementById('total_venta').textContent = totalVenta.toFixed(2);
        calcularVuelto();
        document.getElementById('realizar_venta').disabled = productosVenta.length === 0;
    }

    function calcularVuelto() {
        let montoPagado = parseFloat(document.getElementById('monto_pagado').value) || 0;
        let vuelto = montoPagado - totalVenta;
        let vueltoElement = document.getElementById('vuelto');
        
        if (vuelto >= 0) {
            vueltoElement.textContent = vuelto.toFixed(2);
            vueltoElement.parentElement.classList.remove('text-danger');
            vueltoElement.parentElement.classList.add('text-success');
        } else {
            vueltoElement.textContent = (vuelto * -1).toFixed(2);
            vueltoElement.parentElement.classList.remove('text-success');
            vueltoElement.parentElement.classList.add('text-danger');
        }
    }

    function agregarAlCarrito(button) {
        let productoId = button.getAttribute('data-id');
        let nombre = button.getAttribute('data-nombre');
        let precio = parseFloat(button.getAttribute('data-precio'));
        let stock = parseInt(button.getAttribute('data-stock'));
        let cantidad = 1;

        if (cantidad > stock) {
            alert('No hay suficiente stock');
            return;
        }

        let productoExistente = productosVenta.find(p => p.id == productoId);
        if (productoExistente) {
            productoExistente.cantidad += cantidad;
            productoExistente.subtotal = productoExistente.cantidad * productoExistente.precio;
        } else {
            productosVenta.push({ 
                id: productoId, 
                nombre, 
                cantidad, 
                precio, 
                subtotal: cantidad * precio 
            });
        }

        renderCarrito();
        actualizarTotal();
    }

    function renderCarrito() {
        let carrito = document.getElementById('carrito');
        
        if (productosVenta.length === 0) {
            carrito.innerHTML = `
                <div class="text-muted text-center py-3" id="empty-cart-message">
                    <i class="fas fa-shopping-cart fa-2x mb-2"></i>
                    <p>Tu carrito está vacío</p>
                </div>`;
            return;
        }

        document.getElementById('empty-cart-message')?.remove();
        
        let html = '';
        productosVenta.forEach((p, index) => {
            html += `
            <div class="cart-item">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-1">${p.nombre}</h6>
                        <small class="text-muted">S/ ${p.precio.toFixed(2)} c/u × ${p.cantidad}</small>
                    </div>
                    <div class="d-flex align-items-center">
                        <span class="font-weight-bold mr-3">S/ ${p.subtotal.toFixed(2)}</span>
                        <button class="btn btn-danger btn-sm" onclick="eliminarProducto(${index})">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                    </div>
                </div>
            </div>`;
        });
        
        carrito.innerHTML = html;
    }

    window.eliminarProducto = function(index) {
        productosVenta.splice(index, 1);
        renderCarrito();
        actualizarTotal();
    };

    // Confirmar la venta
    document.getElementById('realizar_venta').addEventListener('click', function() {
        if (productosVenta.length === 0) {
            alert('Agrega productos al carrito antes de realizar la venta.');
            return;
        }

        let montoPagado = parseFloat(document.getElementById('monto_pagado').value) || 0;
        if (montoPagado < totalVenta) {
            alert('El monto recibido es insuficiente.');
            return;
        }

        let alquilerId = document.getElementById('alquiler_id').value;
        if (!alquilerId) {
            alert('Selecciona un cliente antes de realizar la venta.');
            return;
        }

        if (!confirm('¿Confirmar la venta?')) {
            return;
        }

        fetch('/ventas/store', {
            method: 'POST',
            headers: { 
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({
                productos: productosVenta,
                monto_pagado: montoPagado,
                alquiler_id: alquilerId
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Venta registrada con éxito');
                // Resetear todo
                productosVenta = [];
                document.getElementById('monto_pagado').value = '';
                document.getElementById('alquiler_id').value = '';
                renderCarrito();
                actualizarTotal();
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            alert('Error al procesar la venta. Por favor intenta nuevamente.');
            console.error(error);
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/ventas/crear.blade.php ENDPATH**/ ?>