

<?php $__env->startSection('title', 'Lista de Salas de Cine'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1 class="text-center mb-4"><i class="fas fa-film"></i> Salas de Cine</h1>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <!-- Header con acciones -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <button class="btn btn-primary btn-lg shadow" data-bs-toggle="modal" data-bs-target="#modalAgregarSala">
            <i class="fas fa-plus-circle me-2"></i>Agregar Sala
        </button>
        <div class="d-flex gap-2">
            <a href="<?php echo e(route('salas.export-pdf')); ?>" class="btn btn-danger btn-lg shadow" target="_blank">
                <i class="fas fa-file-pdf me-2"></i>PDF
            </a>
            <button class="btn btn-success btn-lg shadow">
                <i class="fas fa-file-excel me-2"></i>Excel
            </button>
        </div>
    </div>

    <!-- Tarjetas de salas -->
    <div class="row g-4">
        <?php $__currentLoopData = $salas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sala): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="card sala-card h-100 <?php echo e($sala->tipo == 'VIP' ? 'vip' : 'normal'); ?>">
                <div class="card-header sala-header d-flex justify-content-between align-items-center">
                <h3 class="sala-title mb-0 text-dark">
    <i class="fas fa-door-open me-2 text-dark"></i><?php echo e(strtoupper($sala->nombre)); ?>

</h3>

                    <?php if(strtolower($sala->estado) == 'disponible'): ?>
                        <span class="badge bg-success rounded-pill px-3 py-2">
                            <i class="fas fa-check-circle me-1"></i> Disponible
                        </span>
                    <?php elseif(strtolower($sala->estado) == 'ocupado'): ?>
                        <span class="badge bg-warning text-dark rounded-pill px-3 py-2">
                            <i class="fas fa-exclamation-triangle me-1"></i> Ocupada
                        </span>
                    <?php elseif(strtolower($sala->estado) == 'mantenimiento'): ?>
                        <span class="badge bg-dark rounded-pill px-3 py-2">
                            <i class="fas fa-tools me-1"></i> Mantenimiento
                        </span>
                    <?php else: ?>
                        <span class="badge bg-secondary rounded-pill px-3 py-2">
                            <i class="fas fa-question-circle me-1"></i> Desconocido
                        </span>
                    <?php endif; ?>
                </div>
                
                <div class="card-body">
                    <!-- Info de la sala -->
                    <div class="sala-info mb-4">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-users fa-lg me-2 text-primary"></i>
                                <span class="fw-bold">Capacidad:</span>
                            </div>
                            <span class="badge bg-primary rounded-pill px-3 py-2"><?php echo e($sala->capacidad); ?> personas</span>
                        </div>
                        
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-tag fa-lg me-2 text-primary"></i>
                                <span class="fw-bold">Tipo:</span>
                            </div>
                            <?php if($sala->tipo == 'VIP'): ?>
                                <span class="badge bg-gold rounded-pill px-3 py-2">
                                    <i class="fas fa-crown me-1"></i> VIP
                                </span>
                            <?php else: ?>
                                <span class="badge bg-purple rounded-pill px-3 py-2">
                                    <i class="fas fa-ticket-alt me-1"></i> Normal
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Acciones -->
                    <div class="sala-actions d-flex justify-content-center gap-2">
                        <a href="<?php echo e(route('salas.edit', $sala)); ?>" class="btn btn-warning btn-lg" title="Editar">
                            <i class="fas fa-edit"></i>
                        </a>
                        
                        <?php if(strtolower($sala->estado) == 'disponible'): ?>
                            <a href="<?php echo e(route('alquileres.create', $sala)); ?>" class="btn btn-success btn-lg" title="Alquilar">
                                <i class="fas fa-calendar-check"></i>
                            </a>
                        <?php else: ?>
                            <button class="btn btn-secondary btn-lg" disabled title="No disponible">
                                <i class="fas fa-ban"></i>
                            </button>
                        <?php endif; ?>
                        
                        <form action="<?php echo e(route('salas.destroy', $sala)); ?>" method="POST" class="d-inline delete-form">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="button" class="btn btn-danger btn-lg delete-btn" title="Eliminar">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Paginación -->
    <div class="d-flex justify-content-center mt-5">
        <?php echo e($salas->links('pagination::bootstrap-5')); ?>

    </div>
</div>

<!-- Modal para Agregar Sala -->
<div class="modal fade" id="modalAgregarSala" tabindex="-1" aria-labelledby="modalAgregarSalaLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="modalAgregarSalaLabel">
                    <i class="fas fa-plus-circle me-2"></i>Agregar Nueva Sala
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formAgregarSala" method="POST" action="<?php echo e(route('salas.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="nombre" name="nombre" required value="<?php echo e(old('nombre')); ?>">
                                <label for="nombre">Nombre de la Sala</label>
                                <small class="form-text text-muted">Ejemplo: SALA 1, SALA 2, SALA VIP 1, etc.</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="number" class="form-control" id="capacidad" name="capacidad" required value="<?php echo e(old('capacidad')); ?>">
                                <label for="capacidad">Capacidad</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <select class="form-select" id="estado" name="estado" required>
                                    <option value="Disponible" <?php echo e(old('estado') == 'Disponible' ? 'selected' : ''); ?>>Disponible</option>
                                    <option value="Ocupado" <?php echo e(old('estado') == 'Ocupado' ? 'selected' : ''); ?>>Ocupado</option>
                                    <option value="Mantenimiento" <?php echo e(old('estado') == 'Mantenimiento' ? 'selected' : ''); ?>>Mantenimiento</option>
                                </select>
                                <label for="estado">Estado</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <select class="form-select" id="tipo" name="tipo" required>
                                    <option value="Normal" <?php echo e(old('tipo') == 'Normal' ? 'selected' : ''); ?>>Normal</option>
                                    <option value="VIP" <?php echo e(old('tipo') == 'VIP' ? 'selected' : ''); ?>>VIP</option>
                                </select>
                                <label for="tipo">Tipo de Sala</label>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer border-0">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary px-4">
                            <i class="fas fa-save me-2"></i>Guardar Sala
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style>
:root {
    --color-primary: #4e73df;
    --color-success: #1cc88a;
    --color-danger: #e74a3b;
    --color-warning: #f6c23e;
    --color-purple: #6f42c1;
    --color-gold: #ffc107;
    --color-dark: #5a5c69;
}

/* Estilos generales */
.sala-card {
    border: none;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
    background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
    height: 100%;
}

.sala-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
}

.sala-header {
    background: var(--color-primary);
    color: white;
    padding: 1rem;
    border-bottom: 3px solid rgba(255, 255, 255, 0.2);
}

.sala-title {
    font-weight: 700;
    font-size: 1.25rem;
    margin: 0;
    color: white;
    text-shadow: 1px 1px 2px rgba(0,0,0,0.3);
}

.sala-info {
    padding: 1rem;
    background: rgba(255, 255, 255, 0.8);
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

/* Badges personalizados */
.badge.bg-success {
    background-color: var(--color-success) !important;
}

.badge.bg-warning {
    background-color: var(--color-warning) !important;
    color: #000 !important;
}

.badge.bg-danger {
    background-color: var(--color-danger) !important;
}

.badge.bg-purple {
    background-color: var(--color-purple) !important;
    color: white !important;
}

.badge.bg-gold {
    background-color: var(--color-gold) !important;
    color: #000 !important;
}

/* Botones */
.btn-lg {
    padding: 0.5rem 1rem;
    font-size: 1rem;
    border-radius: 10px;
    min-width: 40px;
}

/* Estilos específicos para salas VIP */
.sala-card.vip .sala-header {
    background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%);
}

.sala-card.vip .sala-title {
    color: #000;
    text-shadow: 1px 1px 2px rgba(255,255,255,0.3);
}

/* Responsive */
@media (max-width: 768px) {
    .sala-card {
        margin-bottom: 1.5rem;
    }
    
    .sala-actions {
        flex-wrap: wrap;
    }
}

/* Animaciones */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

.sala-card {
    animation: fadeIn 0.5s ease forwards;
}

/* Paginación personalizada */
.pagination .page-item.active .page-link {
    background-color: var(--color-primary);
    border-color: var(--color-primary);
}

.pagination .page-link {
    color: var(--color-primary);
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Confirmación para eliminar
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            Swal.fire({
                title: '¿Eliminar esta sala?',
                text: "¡Esta acción no se puede deshacer!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar',
                backdrop: `
                    rgba(0,0,0,0.5)
                    url("/images/cinema-popcorn.gif")
                    center top
                    no-repeat
                `
            }).then((result) => {
                if (result.isConfirmed) {
                    this.closest('form').submit();
                }
            });
        });
    });

    // AJAX para agregar sala
    $('#formAgregarSala').submit(function(e) {
        e.preventDefault();
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                $('#modalAgregarSala').modal('hide');
                Swal.fire({
                    title: '¡Sala agregada!',
                    text: 'La sala se ha creado correctamente',
                    icon: 'success',
                    confirmButtonColor: '#4e73df'
                }).then(() => {
                    location.reload();
                });
            },
            error: function(xhr) {
                Swal.fire({
                    title: 'Error',
                    text: xhr.responseJSON.message || 'Ocurrió un error',
                    icon: 'error',
                    confirmButtonColor: '#e74a3b'
                });
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/salas/index.blade.php ENDPATH**/ ?>