
<?php $__env->startSection('title', 'Cobros'); ?>

<head>
    <link rel="icon" href="<?php echo e(asset('icons/cobros.png')); ?>" type="image/x-icon">
</head>

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    
<div class="row mb-4">
    
    <div class="col-lg-3 col-md-6 col-12">
        <div class="small-box" style="background-color: #00FF00; color: white; box-shadow: 0px 0px 15px rgba(0, 255, 0, 0.7); min-height: 180px;">
            <div class="inner">
                <h3 class="font-weight-bold" style="font-size: 2rem;">S/<?php echo e(number_format($totalCobrado, 2)); ?></h3>
                <p class="text-uppercase" style="font-size: 1rem; letter-spacing: 1px;">Total Cobrado</p>
            </div>
            <div class="icon"><i class="fas fa-dollar-sign" style="color: white; font-size: 2rem;"></i></div>
        </div>
    </div>

    
    <div class="col-lg-3 col-md-6 col-12">
        <div class="small-box" style="background-color: #FF1493; color: white; box-shadow: 0px 0px 15px rgba(255, 20, 147, 0.7); min-height: 180px;">
            <div class="inner">
                <h3 class="font-weight-bold" style="font-size: 2rem;">S/<?php echo e(number_format($montoPromedio, 2)); ?></h3>
                <p class="text-uppercase" style="font-size: 1rem; letter-spacing: 1px;">Monto Promedio por Cobro</p>
            </div>
            <div class="icon"><i class="fas fa-credit-card" style="color: white; font-size: 2rem;"></i></div>
        </div>
    </div>

    
    <div class="col-lg-3 col-md-6 col-12">
        <div class="small-box" style="background-color: #FF4500; color: white; box-shadow: 0px 0px 15px rgba(255, 69, 0, 0.7); min-height: 180px;">
            <div class="inner">
                <h3 class="font-weight-bold" style="font-size: 2rem;"><?php echo e($cobrosPendientes); ?></h3>
                <p class="text-uppercase" style="font-size: 1rem; letter-spacing: 1px;">Cobros Pendientes</p>
            </div>
            <div class="icon"><i class="fas fa-exclamation-triangle" style="color: white; font-size: 2rem;"></i></div>
        </div>
    </div>

    
    <div class="col-lg-3 col-md-6 col-12">
        <div class="small-box" style="background-color: #00CED1; color: white; box-shadow: 0px 0px 15px rgba(0, 206, 209, 0.7); min-height: 180px;">
            <div class="inner">
                <h3 class="font-weight-bold" style="font-size: 2rem;"><?php echo e($cobrosCompletados); ?></h3>
                <p class="text-uppercase" style="font-size: 1rem; letter-spacing: 1px;">Cobros Completados</p>
            </div>
            <div class="icon"><i class="fas fa-check-circle" style="color: white; font-size: 2rem;"></i></div>
        </div>
    </div>
</div>

    

    <div class="table-responsive">
        <table class="table table-hover table-bordered text-center shadow rounded">
            <thead class="bg-gradient-primary text-white">
                <tr>
                    <th>ID</th>
                    <th>Alquiler ID</th>
                    <th>Nombre de la Película</th>
                    <th>Precio de la Película</th>
                    <th>Monto Pagado</th>
                    <th>Vuelto</th>
                    <th>Fecha</th>
                </tr>
            </thead>
            <tbody class="bg-light">
                <?php $__currentLoopData = $cobros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cobro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="align-middle">
                        <td><strong><?php echo e($cobro->id); ?></strong></td>
                        <td><span class="badge bg-info text-white"><?php echo e($cobro->alquiler_id); ?></span></td>
                        <td>
                            <span class="fw-bold text-primary">
                                <?php echo e($cobro->alquiler->pelicula->titulo ?? 'Sin título'); ?>

                            </span>
                        </td>
                        <td class="text-success">S/<?php echo e(number_format($cobro->alquiler->precio ?? 0, 2)); ?></td>
                        <td class="text-success">S/<?php echo e(number_format($cobro->monto, 2)); ?></td>
                        <td class="text-danger">S/<?php echo e(number_format($cobro->monto - ($cobro->alquiler->precio ?? 0), 2)); ?></td>
                        <td><i class="fas fa-calendar-alt"></i> <?php echo e($cobro->fecha_cobro); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-center mt-3">
        <?php echo e($cobros->links('pagination::bootstrap-4')); ?>

    </div>

    <!-- Sección del gráfico -->
    <h3 class="mt-4 text-center text-primary">Total Cobrado por Película</h3>
    <div class="d-flex justify-content-center">
        <div style="width: 300%; max-width: 2000px;">
            <canvas id="graficoCobros"></canvas>
        </div>
    </div>
</div>

<!-- Estilos personalizados -->
<style>
    .bg-dark {
        background: #343a40 !important;
    }
    .table-hover tbody tr:hover {
        background-color: rgba(52, 58, 64, 0.2);
    }
    .shadow {
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }
    .rounded {
        border-radius: 10px;
    }
</style>

<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function() {
    var ctx = document.getElementById("graficoCobros").getContext("2d");

    // Array de colores para las barras
    var colores = [
        'rgba(255, 99, 132, 0.7)', 
        'rgba(54, 162, 235, 0.7)', 
        'rgba(255, 206, 86, 0.7)', 
        'rgba(75, 192, 192, 0.7)', 
        'rgba(153, 102, 255, 0.7)', 
        'rgba(255, 159, 64, 0.7)', 
        'rgba(255, 99, 71, 0.7)',
        'rgba(60, 179, 113, 0.7)',
        'rgba(238, 130, 238, 0.7)',
        'rgba(255, 69, 0, 0.7)',
        'rgba(0, 255, 255, 0.7)',
        'rgba(255, 140, 0, 0.7)'
    ];

    // Generando colores dinámicos
    var coloresGenerados = <?php echo json_encode($totalesPorPelicula->keys()); ?>.map(function(_, index) {
        return colores[index % colores.length]; // Se usa el operador % para que el índice no se pase del límite
    });

    var data = {
        labels: <?php echo json_encode($totalesPorPelicula->keys()); ?>, // Nombres de películas
        datasets: [{
            label: "Total Recaudado (S/.)",
            data: <?php echo json_encode($totalesPorPelicula->values()); ?>, // Total de cobros
            backgroundColor: coloresGenerados,  // Colores dinámicos
            borderColor: coloresGenerados.map(color => color.replace('0.7', '1')),  // Bordes más intensos
            borderWidth: 1
        }]
    };

    var myChart = new Chart(ctx, {
        type: 'bar',
        data: data,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    title: {
                        display: true,
                        text: 'Total en S/.'
                    }
                },
                x: {
                    title: {
                        display: true,
                        text: 'Películas'
                    }
                }
            },
            animation: {
                duration: 1000,
                easing: 'easeInOutBounce'
            }
        }
    });

    // Búsqueda en la tabla
    document.getElementById('buscar').addEventListener('keyup', function() {
        var value = this.value.toLowerCase();
        var rows = document.querySelectorAll("#tablaCobros tbody tr");

        rows.forEach(function(row) {
            var found = false;
            row.querySelectorAll("td").forEach(function(cell) {
                if (cell.textContent.toLowerCase().includes(value)) {
                    found = true;
                }
            });

            row.style.display = found ? "" : "none";
        });
    });
});

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/cobros/index.blade.php ENDPATH**/ ?>