
<?php $__env->startSection('title', 'Agregar Producto'); ?>

<head>
    <link rel="icon" href="<?php echo e(asset('icons/producto.png')); ?>" type="image/x-icon">
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Estilos adicionales -->
    <style>
        .image-preview-container {
            display: none;
            margin-top: 15px;
            text-align: center;
        }
        .image-preview {
            max-width: 100%;
            max-height: 200px;
            border-radius: 8px;
            border: 2px dashed #ddd;
            padding: 10px;
        }
        .upload-area {
            border: 2px dashed #ccc;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
        }
        .upload-area:hover {
            border-color: #0d6efd;
            background-color: #f8f9fa;
        }
        .upload-icon {
            font-size: 48px;
            color: #6c757d;
            margin-bottom: 10px;
        }
    </style>
</head>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h3 class="card-title mb-0">
                        <i class="fas fa-cube"></i> Agregar Nuevo Producto
                    </h3>
                </div>
                
                <div class="card-body">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <strong><i class="fas fa-exclamation-triangle"></i> Error!</strong>
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <form action="<?php echo e(route('productos.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="nombre" class="form-label fw-bold">Nombre del Producto</label>
                                    <input type="text" name="nombre" id="nombre" class="form-control form-control-lg" 
                                           value="<?php echo e(old('nombre')); ?>" required placeholder="Ej. Laptop HP 15-dw1025la">
                                </div>

                                <div class="mb-3">
                                    <label for="precio" class="form-label fw-bold">Precio (S/)</label>
                                    <div class="input-group">
                                        <span class="input-group-text">S/</span>
                                        <input type="number" name="precio" id="precio" class="form-control form-control-lg" 
                                               step="0.01" value="<?php echo e(old('precio')); ?>" required placeholder="0.00">
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="stock" class="form-label fw-bold">Stock Disponible</label>
                                    <input type="number" name="stock" id="stock" class="form-control form-control-lg" 
                                           value="<?php echo e(old('stock')); ?>" required placeholder="Cantidad en almacén">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Imagen del Producto</label>
                                    <div class="upload-area" id="uploadArea">
                                        <div class="upload-icon">
                                            <i class="fas fa-cloud-upload-alt"></i>
                                        </div>
                                        <p class="mb-2">Arrastra y suelta tu imagen aquí</p>
                                        <p class="text-muted small">o haz clic para seleccionar</p>
                                        <input type="file" name="imagen" id="imagen" class="d-none" accept="image/*">
                                    </div>
                                    <div class="form-text mt-2">Formatos soportados: JPG, PNG, JPEG. Tamaño máximo: 2MB.</div>
                                    
                                    <div class="image-preview-container" id="imagePreviewContainer">
                                        <p class="fw-bold mb-2">Vista previa:</p>
                                        <img src="#" alt="Vista previa de la imagen" class="image-preview" id="imagePreview">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between mt-4">
                            <a href="<?php echo e(route('productos.index')); ?>" class="btn btn-secondary btn-lg">
                                <i class="fas fa-arrow-left"></i> Cancelar
                            </a>
                            <button type="submit" class="btn btn-success btn-lg px-4">
                                <i class="fas fa-save"></i> Guardar Producto
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('js'); ?>
<!-- Bootstrap 5 JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<!-- Script para vista previa de imagen -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const uploadArea = document.getElementById('uploadArea');
    const fileInput = document.getElementById('imagen');
    const previewContainer = document.getElementById('imagePreviewContainer');
    const previewImage = document.getElementById('imagePreview');

    // Click en el área de upload
    uploadArea.addEventListener('click', function() {
        fileInput.click();
    });

    // Cambio en el input de archivo
    fileInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            
            reader.onload = function(event) {
                previewImage.src = event.target.result;
                previewContainer.style.display = 'block';
                uploadArea.style.display = 'none';
            };
            
            reader.readAsDataURL(file);
        }
    });

    // Arrastrar y soltar
    uploadArea.addEventListener('dragover', function(e) {
        e.preventDefault();
        uploadArea.style.borderColor = '#0d6efd';
        uploadArea.style.backgroundColor = '#e7f1ff';
    });

    uploadArea.addEventListener('dragleave', function() {
        uploadArea.style.borderColor = '#ccc';
        uploadArea.style.backgroundColor = '';
    });

    uploadArea.addEventListener('drop', function(e) {
        e.preventDefault();
        uploadArea.style.borderColor = '#ccc';
        uploadArea.style.backgroundColor = '';
        
        if (e.dataTransfer.files.length) {
            fileInput.files = e.dataTransfer.files;
            const changeEvent = new Event('change');
            fileInput.dispatchEvent(changeEvent);
        }
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/productos/create.blade.php ENDPATH**/ ?>