<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ticket Alquiler</title>
    <style>
        body {
            font-family: "Courier New", monospace;
            font-size: 14px;
            text-align: left;
            width: 80mm;
            margin: 0;
            padding: 2mm 0 0 1mm;
            background: white;
        }

        .ticket {
            width: 100%;
            padding: 0;
        }

        .titulo {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 3px;
        }

        .linea {
            display: block;
            font-size: 14px;
            margin: 2px 0;
        }

        .info {
            font-size: 13px;
            margin: 0;
            padding: 0;
        }

        .resaltado {
            font-weight: bold;
        }

        .qr-container {
            margin: 5px 0;
            text-align: left;
        }

        .qr-code {
            width: 50px;
            height: 50px;
        }

        .agradecimiento {
            font-size: 13px;
            margin-top: 5px;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="ticket">
        <div class="titulo">CINE WINDER</div>
        <span class="linea">-------------------------</span>
        
        <p class="info"><span class="resaltado">N° Ticket:</span> <?php echo e($alquiler->id); ?></p>
        <p class="info"><span class="resaltado">Fecha:</span> <?php echo e(now()->format('d/m/Y H:i')); ?></p>
        
        <?php
            $nombreCompleto = explode(' ', trim($alquiler->cliente));
            $nombres = implode(' ', array_slice($nombreCompleto, 0, 2));
            $apellidos = implode(' ', array_slice($nombreCompleto, 2));
            $primerNombre = $nombreCompleto[0] ?? '';
            $primerApellido = $nombreCompleto[2] ?? ($nombreCompleto[1] ?? '');
            
            // Datos para el QR (puedes personalizar esta información)
            $qrData = "CINE WINDER\n";
            $qrData .= "Ticket: #".$alquiler->id."\n";
            $qrData .= "Película: ".($alquiler->pelicula->titulo ?? 'Sin título')."\n";
            $qrData .= "Sala: ".($alquiler->sala->nombre ?? 'Sin sala')."\n";
            $qrData .= "Horario: ".$alquiler->hora_entrada." - ".$alquiler->hora_salida."\n";
            $qrData .= "Cliente: ".$alquiler->cliente."\n";
            $qrData .= "Precio: S/ ".number_format($alquiler->precio, 2);
        ?>

        <p class="info"><span class="resaltado">Cliente:</span> <?php echo e($nombres); ?></p>
        <p class="info"><span class="resaltado">Apellidos:</span> <?php echo e($apellidos); ?></p>
        <p class="info"><span class="resaltado">Película:</span> <?php echo e($alquiler->pelicula->titulo ?? 'Sin título'); ?></p>
        <p class="info"><span class="resaltado">Sala:</span> <?php echo e($alquiler->sala->nombre ?? 'Sin sala'); ?></p>
        <p class="info"><span class="resaltado">Entrada:</span> <?php echo e(date('H:i', strtotime($alquiler->hora_entrada))); ?></p>
        <p class="info"><span class="resaltado">Salida:</span> <?php echo e(date('H:i', strtotime($alquiler->hora_salida))); ?></p>
        <p class="info"><span class="resaltado">Duración:</span> <?php echo e($alquiler->pelicula->duracion ?? 'N/A'); ?> min</p>
        <p class="info"><span class="resaltado">Asientos:</span> <?php echo e($alquiler->asientos ?? 'Libre'); ?></p>
        <p class="info"><span class="resaltado">Método de Pago:</span> <?php echo e(ucfirst($alquiler->metodo_pago ?? 'Efectivo')); ?></p>
        <p class="info"><span class="resaltado">Código Reserva:</span> CE-<?php echo e(strtoupper(substr($primerNombre, 0, 1))); ?><?php echo e(strtoupper(substr($primerApellido, 0, 1))); ?>-<?php echo e($alquiler->id); ?></p>
        <p class="info"><span class="resaltado">Precio:</span> S/ <?php echo e(number_format($alquiler->precio, 2)); ?></p>
        <p class="info"><span class="resaltado">Atendido por:</span> <?php echo e($alquiler->empleado ?? 'Elvis'); ?></p>

        <span class="linea">-------------------------</span>

        <!-- Implementación del QR -->
        <div class="qr-container">
            <img src="https://api.qrserver.com/v1/create-qr-code/?size=100x100&data=<?php echo e(urlencode($qrData)); ?>" 
                 alt="Código QR del ticket" class="qr-code">
            <div>Escanea para validar</div>
        </div>

        <p class="agradecimiento">¡Gracias por su visita!</p>
    </div>
</body>
</html><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/alquileres/ticket.blade.php ENDPATH**/ ?>