<?php $layoutHelper = app('JeroenNoten\LaravelAdminLte\Helpers\LayoutHelper'); ?>

<nav class="main-header navbar
    <?php echo e(config('adminlte.classes_topnav_nav', 'navbar-expand')); ?>

    <?php echo e(config('adminlte.classes_topnav', 'navbar-white navbar-light')); ?>">

    
    <ul class="navbar-nav">
        
        <?php echo $__env->make('adminlte::partials.navbar.menu-item-left-sidebar-toggler', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        
        <?php echo $__env->renderEach('adminlte::partials.navbar.menu-item', $adminlte->menu('navbar-left'), 'item'); ?>

        
        <?php echo $__env->yieldContent('content_top_nav_left'); ?>
    </ul>

    
    <ul class="navbar-nav ml-auto">
        
        <li class="nav-item">
            <a href="#" class="nav-link" id="theme-toggle" data-toggle="tooltip" title="Cambiar tema">
                <i class="fas fa-moon" id="dark-icon"></i>
                <i class="fas fa-sun" id="light-icon" style="display: none;"></i>
            </a>
        </li>

        
        <?php echo $__env->yieldContent('content_top_nav_right'); ?>

        
        <?php echo $__env->renderEach('adminlte::partials.navbar.menu-item', $adminlte->menu('navbar-right'), 'item'); ?>

        
        <?php if(Auth::user()): ?>
            <?php if(config('adminlte.usermenu_enabled')): ?>
                <?php echo $__env->make('adminlte::partials.navbar.menu-item-dropdown-user-menu', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('adminlte::partials.navbar.menu-item-logout-link', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php endif; ?>
        <?php endif; ?>

        
        <?php if($layoutHelper->isRightSidebarEnabled()): ?>
            <?php echo $__env->make('adminlte::partials.navbar.menu-item-right-sidebar-toggler', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>
    </ul>
</nav>

<style>
    /* Estilos para el icono de tema */
    #theme-toggle {
        font-size: 1.2rem;
        padding: 0.5rem;
    }
    
    #light-icon {
        color: #f39c12;
    }
    
    #dark-icon {
        color: #6c757d;
    }
    
    /* Estilos para modo oscuro */
    .dark-mode {
        background-color: #343a40;
        color: #f8f9fa;
    }
    
    .dark-mode .main-header {
        background-color: #343a40 !important;
        border-bottom: 1px solid #454d55;
    }
    
    .dark-mode .navbar-light .navbar-nav .nav-link {
        color: rgba(255, 255, 255, 0.8);
    }
    
    .dark-mode .navbar-light .navbar-nav .nav-link:hover {
        color: rgba(255, 255, 255, 1);
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const themeToggle = document.getElementById('theme-toggle');
        const body = document.body;
        const darkIcon = document.getElementById('dark-icon');
        const lightIcon = document.getElementById('light-icon');
        
        // Verificar preferencia guardada
        if (localStorage.getItem('theme') === 'dark') {
            body.classList.add('dark-mode');
            darkIcon.style.display = 'none';
            lightIcon.style.display = 'inline';
        } else {
            darkIcon.style.display = 'inline';
            lightIcon.style.display = 'none';
        }
        
        // Escuchar clic en el icono
        themeToggle.addEventListener('click', function(e) {
            e.preventDefault();
            
            if (body.classList.contains('dark-mode')) {
                body.classList.remove('dark-mode');
                localStorage.setItem('theme', 'light');
                darkIcon.style.display = 'inline';
                lightIcon.style.display = 'none';
            } else {
                body.classList.add('dark-mode');
                localStorage.setItem('theme', 'dark');
                darkIcon.style.display = 'none';
                lightIcon.style.display = 'inline';
            }
        });

        // Detectar preferencia del sistema
        const prefersDarkScheme = window.matchMedia('(prefers-color-scheme: dark)');
        
        if (prefersDarkScheme.matches && !localStorage.getItem('theme')) {
            body.classList.add('dark-mode');
            darkIcon.style.display = 'none';
            lightIcon.style.display = 'inline';
        }
        
        prefersDarkScheme.addListener(e => {
            if (!localStorage.getItem('theme')) {
                if (e.matches) {
                    body.classList.add('dark-mode');
                    darkIcon.style.display = 'none';
                    lightIcon.style.display = 'inline';
                } else {
                    body.classList.remove('dark-mode');
                    darkIcon.style.display = 'inline';
                    lightIcon.style.display = 'none';
                }
            }
        });
    });
</script><?php /**PATH C:\xampp\htdocs\cinema-laravel11\vendor\jeroennoten\laravel-adminlte\src/../resources/views/partials/navbar/navbar.blade.php ENDPATH**/ ?>