

<?php $__env->startSection('title', 'Agregar Película'); ?>
<head>
    <link rel="icon" href="<?php echo e(asset('icons/pelicula.png')); ?>" type="image/x-icon">
</head>
<?php $__env->startSection('content_header'); ?>
    <h1 class="text-center text-dark font-weight-bold">🎬 Agregar Nueva Película</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-center">
    <div class="card shadow-lg border-0 col-12 col-md-8 col-lg-6 col-xl-4">
        <div class="card-body bg-light p-4 rounded">
            <form action="<?php echo e(route('peliculas.store')); ?>" method="POST" enctype="multipart/form-data" class="p-3 border rounded bg-white shadow-sm">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label class="font-weight-bold">Título</label>
                    <input type="text" name="titulo" class="form-control border border-dark rounded p-2 shadow-sm bg-white" required>
                </div>
                <div class="form-group">
                    <label class="font-weight-bold">Duración</label>
                    <div class="d-flex">
                        <input type="number" name="horas" class="form-control border border-dark rounded p-2 shadow-sm bg-white" placeholder="Horas" min="0" required>
                        <span class="px-2 font-weight-bold">h</span>
                        <input type="number" name="minutos" class="form-control border border-dark rounded p-2 shadow-sm bg-white ml-2" placeholder="Minutos" min="0" max="59" required>
                        <span class="px-2 font-weight-bold">min</span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="font-weight-bold">Formato</label>
                    <input type="text" name="formato" class="form-control border border-dark rounded p-2 shadow-sm bg-white" required>
                </div>
                <div class="form-group">
                    <label class="font-weight-bold">Categoría</label>
                    <select name="categoria_id" class="form-control border border-dark rounded p-2 shadow-sm bg-white" required>
                        <option value="">Selecciona una categoría</option>
                        <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($categoria->id); ?>"><?php echo e($categoria->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group">
                    <label class="font-weight-bold">Estado</label>
                    <select name="estado" class="form-control border border-dark rounded p-2 shadow-sm bg-white" required>
                        <option value="disponible">Disponible</option>
                        <option value="alquilada">Alquilada</option>
                    </select>
                </div>
                <!-- Eliminar el campo de imagen -->
                <div class="d-flex justify-content-between">
                    <button type="submit" class="btn btn-lg btn-primary shadow">💾 Guardar</button>
                    <a href="<?php echo e(route('peliculas.index')); ?>" class="btn btn-lg btn-secondary shadow">❌ Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/peliculas/create.blade.php ENDPATH**/ ?>