<?php
use App\Http\Controllers\ReporteController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\PeliculaController;
use App\Http\Controllers\CategoriaController;
use App\Http\Controllers\SalaController;
use App\Http\Controllers\AlquilerController;
use App\Http\Controllers\ClienteController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TicketController;
use App\Models\Alquiler;
use App\Http\Controllers\UserController;
use App\Http\Controllers\CobroController;
use App\Http\Controllers\DniController;
use App\Http\Controllers\ProductoController;
use App\Http\Controllers\AlquilerProductoController;
// Si estás usando Laravel's Auth predeterminado, la ruta de inicio podría ser algo como esto:
Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth'])->name('dashboard');

Route::get('/', function () {
    return redirect()->route('login');
});


use App\Http\Controllers\DashboardController;

Route::get('/dashboard', [DashboardController::class, 'index'])
    ->middleware(['auth', 'verified'])
    ->name('dashboard');
    Route::get('/dashboard/cobros', [DashboardController::class, 'getCobros']);

    Route::get('/dashboard/ingresos-diarios', [DashboardController::class, 'ingresosDiarios'])->name('dashboard.ingresos-diarios');
// Ruta de búsqueda de películas fuera del middleware de autenticación
Route::get('/peliculas/search', [PeliculaController::class, 'search'])->name('peliculas.search');


Route::get('/peliculas/exportar-pdf', [PeliculaController::class, 'exportToPDF'])->name('peliculas.export-pdf');
Route::post('/peliculas/import', [PeliculaController::class, 'import'])->name('peliculas.import');
// Ruta para exportar a Excel
Route::get('peliculas/export-excel', [PeliculaController::class, 'exportExcel'])->name('peliculas.export-excel');


// Ruta para mostrar la vista
Route::get('/categorias', [CategoriaController::class, 'index'])->name('categorias.index');

// Ruta para obtener categorías en formato JSON
Route::get('/categorias/json', [CategoriaController::class, 'obtenerCategorias'])->name('categorias.json');





Route::get('/salas/exportar-pdf', [SalaController::class, 'exportToPDF'])->name('salas.export-pdf');

Route::get('/cobros/exportar-pdf', [CobroController::class, 'exportToPDF'])->name('cobros.export-pdf');

Route::post('/alquileres/cobrar/{id}', [AlquilerController::class, 'cobrar'])->name('alquileres.cobrar');

Route::post('/cobros/{id}', [CobroController::class, 'procesarCobro'])->name('cobros.procesar');

Route::post('/guardar-pago', [AlquilerController::class, 'guardarPago']);
Route::post('/cobrar/{id}', [AlquilerController::class, 'cobrar']);

Route::get('/usuarios/{id}/es-super-admin', [UserController::class, 'esSuperAdmin']);
Route::post('/usuarios/{id}/estado', [UserController::class, 'cambiarEstado']);

Route::get('/usuarios', [UserController::class, 'index'])->name('usuarios.index');
Route::get('/usuarios/create', [UserController::class, 'create'])->name('usuarios.create');
Route::post('/usuarios', [UserController::class, 'store'])->name('usuarios.store');
Route::delete('/usuarios/{id}', [UserController::class, 'destroy'])->name('usuarios.destroy');


Route::get('/usuarios/{id}/edit', [UserController::class, 'edit'])->name('usuarios.edit');
Route::delete('/usuarios/{id}', [UserController::class, 'destroy'])->name('usuarios.destroy');


Route::put('/usuarios/{id}', [UserController::class, 'update'])->name('usuarios.update');

use App\Http\Controllers\VentaController;
Route::get('/ventatotal', [VentaController::class, 'ventatotal'])->name('ventas.ventatotal');
Route::delete('/ventas/{id}', [VentaController::class, 'destroy'])->name('ventas.destroy');
Route::get('/ventas/crear', [VentaController::class, 'crear'])->name('ventas.crear');
Route::post('/ventas', [VentaController::class, 'store'])->name('ventas.store');
Route::get('/ventas', [VentaController::class, 'index'])->name('ventas.index');
Route::post('/ventas', [VentaController::class, 'store'])->name('ventas.store');
Route::post('/ventas/store', [VentaController::class, 'store']);


// 📌 DNI
Route::get('/dni', [DniController::class, 'index']);
Route::post('/dni/search', [DniController::class, 'search'])->name('dni.search');


Route::resource('productos', ProductoController::class);
Route::resource('alquileres', AlquilerController::class);

Route::post('/usuarios/{usuario}/enviar-codigo-recuperacion', [UsuarioController::class, 'enviarCodigoRecuperacion'])
    ->name('usuarios.enviar-codigo-recuperacion');


Route::post('/alquiler/{alquilerId}/agregar-producto', [AlquilerController::class, 'agregarProducto'])->name('alquiler.agregarProducto');



Route::post('/alquiler-productos', [AlquilerProductoController::class, 'store']);
Route::get('alquiler/export-excel', [AlquilerController::class, 'exportExcel'])->name('alquiler.export-excel');


Route::resource('productos', ProductoController::class);

Route::post('productos/{id}/vender', [ProductoController::class, 'vender'])->name('productos.vender');
Route::get('productos/{id}/ticket', [ProductoController::class, 'generarTicket'])->name('productos.ticket');
Route::get('productos-listado', [ProductoController::class, 'listarProductos'])->name('productos.listar');

// Rutas API en web.php o api.php
Route::get('/api/productos/stock-bajo', [ProductoController::class, 'obtenerProductosStockBajo']);

Route::get('/api/notificaciones', function () {
    $productosStockBajo = Producto::where('stock', '<', 5)->get(); // Productos con stock bajo
    return response()->json($productosStockBajo);
});
Route::get('/dashboard/ingresos-productos-diarios', [DashboardController::class, 'ingresosProductosDiarios'])
    ->name('dashboard.ingresos-productos');

Route::get('/productos/lista', [ProductoController::class, 'listarProductos'])->name('productos.lista');

Route::post('/alquileres', [AlquilerController::class, 'store'])->name('alquileres.store');

Route::get('alquileres/create', [AlquilerController::class, 'create'])->name('alquileres.create');

Route::get('/usuarios/crear', [UserController::class, 'create'])->name('usuarios.create');
Route::post('/usuarios', [UserController::class, 'store'])->name('usuarios.store');


Route::get('/cobros', [CobroController::class, 'index'])->name('cobros.index');
Route::post('/cobros', [CobroController::class, 'store'])->name('cobros.store');


// 📌 ticket
Route::get('/alquileres/{id}/ticket', [AlquilerController::class, 'generarTicket'])->name('ticket.pdf');



Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // 📌 Rutas protegidas por autenticación
    Route::resource('peliculas', PeliculaController::class);
    Route::resource('categorias', CategoriaController::class);
    Route::resource('salas', SalaController::class);
    Route::resource('alquileres', AlquilerController::class);
    Route::resource('clientes', ClienteController::class);
    Route::resource('productos', ProductoController::class);
    Route::resource('alquileres', AlquilerController::class);

    Route::get('/reporte', [ReporteController::class, 'index'])->name('reporte.index');



// Rutas para exportar ventas y alquileres a Excel
Route::post('/ventas/export-excel', [ReporteController::class, 'exportVentasExcel'])->name('ventas.export-excel');
Route::post('/exportar-alquileres-excel', [ReporteController::class, 'exportAlquileresExcel'])->name('exportar-alquileres-excel');

});



// 📌 Mantén esta línea al final para manejar la autenticación
require __DIR__.'/auth.php';
