@extends('adminlte::page')

@section('title', 'Editar Usuario')

@section('content_header')
<div class="d-flex justify-content-between align-items-center">
    <h1 class="m-0 text-dark"><i class="fas fa-user-edit mr-2"></i>Editar Usuario</h1>
    <a href="{{ route('usuarios.index') }}" class="btn btn-outline-secondary btn-sm">
        <i class="fas fa-arrow-left mr-1"></i> Volver
    </a>
</div>
@stop

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="card card-gradient">
                <div class="card-header bg-gradient-primary py-3">
                    <h3 class="card-title text-white mb-0"><i class="fas fa-user-cog mr-2"></i>Información del Usuario</h3>
                </div>
                <form action="{{ route('usuarios.update', $usuario->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="card-body py-3">
                        <!-- Foto de Perfil Compacta - Corregido el estilo que se mostraba como texto -->
                        <div class="form-group text-center mb-3">
                            <div class="position-relative d-inline-block">
                                @if($usuario->foto)
                                    <img id="profileImagePreview" src="{{ asset('storage/' . $usuario->foto) }}" 
                                         class="rounded-circle shadow border border-white" 
                                         width="120" height="120"
                                         style="object-fit: cover; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
                                @else
                                    <div id="profileImagePreview" 
                                         class="rounded-circle bg-gradient-light d-flex align-items-center justify-content-center shadow" 
                                         style="width: 120px; height: 120px; border: 2px solid #6777ef;
                                                background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);">
                                        <i class="fas fa-user text-muted" style="font-size: 3rem; opacity: 0.7;"></i>
                                    </div>
                                @endif
                                <label for="foto" class="btn btn-primary btn-circle position-absolute hover-animate" 
                                       style="bottom: 8px; right: 8px; width: 30px; height: 30px; cursor: pointer;
                                              box-shadow: 0 2px 8px rgba(103, 119, 239, 0.4);">
                                    <i class="fas fa-camera" style="font-size: 0.8rem;"></i>
                                </label>
                                <input type="file" name="foto" id="foto" class="d-none" accept="image/*">
                            </div>
                            <div class="mt-2">
                                <button type="button" id="removePhotoBtn" 
                                        class="btn btn-outline-danger btn-xs rounded-pill {{ $usuario->foto ? '' : 'd-none' }}" 
                                        onclick="removeProfileImage()">
                                    <i class="fas fa-trash-alt mr-1"></i> Eliminar
                                </button>
                            </div>
                            <small class="form-text text-muted mt-1" style="font-size: 0.75rem;">Formatos: JPG, PNG (Max. 2MB)</small>
                        </div>

                        <!-- Campos del formulario -->
                        <div class="form-group mb-3">
                            <label for="name" class="form-label small">
                                <i class="fas fa-user-tag mr-1 text-primary"></i>Nombre Completo
                            </label>
                            <div class="input-group input-group-sm">
                                <div class="input-group-prepend">
                                    <span class="input-group-text bg-soft-primary border-0 py-2">
                                        <i class="fas fa-user text-primary"></i>
                                    </span>
                                </div>
                                <input type="text" name="name" id="name" 
                                       class="form-control form-control-sm border-left-0 @error('name') is-invalid @enderror" 
                                       value="{{ old('name', $usuario->name) }}" required
                                       placeholder="Nombre completo">
                            </div>
                            @error('name')
                                <div class="invalid-feedback d-block mt-1 small">
                                    <i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="form-group mb-3">
                            <label for="email" class="form-label small">
                                <i class="fas fa-at mr-1 text-primary"></i>Correo Electrónico
                            </label>
                            <div class="input-group input-group-sm">
                                <div class="input-group-prepend">
                                    <span class="input-group-text bg-soft-primary border-0 py-2">
                                        <i class="fas fa-envelope text-primary"></i>
                                    </span>
                                </div>
                                <input type="email" name="email" id="email" 
                                       class="form-control form-control-sm border-left-0 @error('email') is-invalid @enderror" 
                                       value="{{ old('email', $usuario->email) }}" required
                                       placeholder="Correo electrónico">
                            </div>
                            @error('email')
                                <div class="invalid-feedback d-block mt-1 small">
                                    <i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="form-group mb-3">
                            <label for="password" class="form-label small">
                                <i class="fas fa-key mr-1 text-primary"></i>Nueva Contraseña
                            </label>
                            <div class="input-group input-group-sm">
                                <div class="input-group-prepend">
                                    <span class="input-group-text bg-soft-primary border-0 py-2">
                                        <i class="fas fa-lock text-primary"></i>
                                    </span>
                                </div>
                                <input type="password" name="password" id="password" 
                                       class="form-control form-control-sm border-left-0 @error('password') is-invalid @enderror" 
                                       placeholder="Dejar vacío para no cambiar">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary border-left-0 toggle-password hover-animate py-1 px-2" type="button">
                                        <i class="fas fa-eye" style="font-size: 0.8rem;"></i>
                                    </button>
                                </div>
                            </div>
                            @error('password')
                                <div class="invalid-feedback d-block mt-1 small">
                                    <i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}
                                </div>
                            @enderror
                            <small class="form-text text-muted mt-1 small">Mínimo 8 caracteres</small>
                        </div>

                        <div class="form-group mb-3">
                            <label for="password_confirmation" class="form-label small">
                                <i class="fas fa-key mr-1 text-primary"></i>Confirmar Contraseña
                            </label>
                            <div class="input-group input-group-sm">
                                <div class="input-group-prepend">
                                    <span class="input-group-text bg-soft-primary border-0 py-2">
                                        <i class="fas fa-lock text-primary"></i>
                                    </span>
                                </div>
                                <input type="password" name="password_confirmation" id="password_confirmation" 
                                       class="form-control form-control-sm border-left-0" 
                                       placeholder="Confirmar contraseña">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary border-left-0 toggle-password hover-animate py-1 px-2" type="button">
                                        <i class="fas fa-eye" style="font-size: 0.8rem;"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer bg-white border-top-0 text-right py-3 px-3">
                        <button type="reset" class="btn btn-outline-secondary btn-sm rounded-pill mr-2 px-3">
                            <i class="fas fa-undo-alt mr-1"></i> Restablecer
                        </button>
                        <button type="submit" class="btn btn-primary btn-sm rounded-pill px-3 shadow-sm">
                            <i class="fas fa-save mr-1"></i> Guardar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
    .card-gradient {
        border: none;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    }
    
    .bg-gradient-primary {
        background: linear-gradient(135deg, #6777ef 0%, #5a6bd8 100%) !important;
    }
    
    .bg-soft-primary {
        background-color: rgba(103, 119, 239, 0.1) !important;
    }
    
    .form-label {
        font-weight: 600;
        color: #4a5568;
        margin-bottom: 0.3rem;
        display: block;
    }
    
    .form-label.small {
        font-size: 0.8rem;
    }
    
    .form-control-sm {
        height: calc(1.8125rem + 2px);
        padding: 0.25rem 0.5rem;
        font-size: 0.875rem;
        border-radius: 0 0.25rem 0.25rem 0 !important;
    }
    
    .input-group-sm > .form-control,
    .input-group-sm > .input-group-prepend > .input-group-text {
        border-radius: 0.25rem !important;
        padding: 0.25rem 0.5rem;
    }
    
    .input-group-text {
        border-radius: 0.25rem 0 0 0.25rem !important;
        border-right: none;
    }
    
    .btn-circle {
        border-radius: 50%;
        width: 30px;
        height: 30px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        font-size: 0.8rem;
    }
    
    .rounded-pill {
        border-radius: 50rem !important;
    }
    
    .hover-animate {
        transition: all 0.2s ease;
    }
    
    .hover-animate:hover {
        transform: translateY(-1px);
    }
    
    #profileImagePreview {
        transition: all 0.2s cubic-bezier(0.25, 0.8, 0.25, 1);
    }
    
    #profileImagePreview:hover {
        transform: scale(1.02);
        box-shadow: 0 6px 20px rgba(0,0,0,0.1) !important;
    }
    
    .toggle-password {
        cursor: pointer;
        transition: all 0.2s;
        font-size: 0.8rem;
    }
    
    .toggle-password:hover {
        background-color: #f8f9fa !important;
    }
    
    .btn-primary {
        background-color: #6777ef;
        border-color: #6777ef;
        transition: all 0.2s;
    }
    
    .btn-primary:hover {
        background-color: #5a6bd8;
        border-color: #5a6bd8;
        transform: translateY(-1px);
        box-shadow: 0 3px 10px rgba(103, 119, 239, 0.3);
    }
    
    .btn-outline-secondary:hover {
        transform: translateY(-1px);
        box-shadow: 0 3px 8px rgba(0,0,0,0.08);
    }
    
    .btn-outline-danger:hover {
        transform: translateY(-1px);
        box-shadow: 0 3px 8px rgba(220, 53, 69, 0.15);
    }
    
    .small {
        font-size: 0.85rem;
    }
    
    .btn-xs {
        padding: 0.15rem 0.5rem;
        font-size: 0.75rem;
        line-height: 1.5;
    }
</style>
@stop

@section('js')
<script>
    // Vista previa de la imagen seleccionada
    document.getElementById('foto').addEventListener('change', function(event) {
        const preview = document.getElementById('profileImagePreview');
        const file = event.target.files[0];
        const reader = new FileReader();
        
        reader.onload = function(e) {
            if (preview.tagName === 'IMG') {
                preview.src = e.target.result;
            } else {
                // Si es el div, lo reemplazamos por una imagen
                const newPreview = document.createElement('img');
                newPreview.id = 'profileImagePreview';
                newPreview.src = e.target.result;
                newPreview.className = 'rounded-circle shadow border border-white';
                newPreview.style.width = '120px';
                newPreview.style.height = '120px';
                newPreview.style.objectFit = 'cover';
                newPreview.style.boxShadow = '0 4px 15px rgba(0,0,0,0.1)';
                preview.parentNode.replaceChild(newPreview, preview);
            }
            document.getElementById('removePhotoBtn').classList.remove('d-none');
        }
        
        if (file) {
            // Validar tamaño máximo (2MB)
            if (file.size > 2 * 1024 * 1024) {
                Swal.fire({
                    icon: 'error',
                    title: 'Archivo demasiado grande',
                    text: 'La imagen no debe exceder los 2MB',
                    confirmButtonColor: '#6777ef',
                    customClass: {
                        popup: 'small'
                    }
                });
                this.value = '';
                return;
            }
            reader.readAsDataURL(file);
        }
    });

    // Eliminar foto de perfil
    function removeProfileImage() {
        const previewContainer = document.getElementById('profileImagePreview').parentNode;
        const newPreview = document.createElement('div');
        newPreview.id = 'profileImagePreview';
        newPreview.className = 'rounded-circle bg-gradient-light d-flex align-items-center justify-content-center shadow';
        newPreview.style.width = '120px';
        newPreview.style.height = '120px';
        newPreview.style.border = '2px solid #6777ef';
        newPreview.style.background = 'linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%)';
        
        const icon = document.createElement('i');
        icon.className = 'fas fa-user text-muted';
        icon.style.fontSize = '3rem';
        icon.style.opacity = '0.7';
        
        newPreview.appendChild(icon);
        previewContainer.replaceChild(newPreview, document.getElementById('profileImagePreview'));
        
        document.getElementById('foto').value = '';
        document.getElementById('removePhotoBtn').classList.add('d-none');
    }

    // Mostrar/ocultar contraseña
    document.querySelectorAll('.toggle-password').forEach(button => {
        button.addEventListener('click', function() {
            const input = this.closest('.input-group').querySelector('input');
            const icon = this.querySelector('i');
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        });
    });
</script>
@stop