@extends('adminlte::page')

@section('title', 'Reporte Diario de Ventas y Alquileres')

@section('content_header')
<style>
    :root {
        --primary-color: #4e73df;
        --secondary-color: #1cc88a;
    }
    
    .table-wrapper {
        position: relative;
        margin-bottom: 15px;
        border: 1px solid #e3e6f0;
        border-radius: 5px;
        height: 120px; /* Altura para 2 filas */
        overflow: hidden;
    }
    
    .table-container {
        height: calc(120px - 40px); /* Restamos la altura del header */
        overflow-y: auto;
    }
    
    /* Estilo del scroll */
    .table-container::-webkit-scrollbar {
        width: 6px;
    }
    
    .table-container::-webkit-scrollbar-track {
        background: #f1f1f1;
    }
    
    .table-container::-webkit-scrollbar-thumb {
        background: #888;
        border-radius: 3px;
    }
    
    .table-container::-webkit-scrollbar-thumb:hover {
        background: #555;
    }
    
    .table-header {
        position: sticky;
        top: 0;
        z-index: 10;
        background-color: inherit;
    }
    
    .ventas-table .table-header {
        background-color: var(--primary-color);
        color: white;
    }
    
    .alquileres-table .table-header {
        background-color: var(--secondary-color);
        color: white;
    }
    
    .table {
        margin-bottom: 0;
        width: 100%;
    }
    
    .table th, .table td {
        padding: 8px 12px;
        vertical-align: middle;
        text-align: center;
    }
    
    .table tbody tr {
        height: 40px; /* Altura fija para cada fila */
    }
    
    .btn-export {
        border-radius: 4px;
        font-weight: 500;
        padding: 6px 12px;
        font-size: 13px;
    }
    
    /* Ajustes para las columnas */
    .col-id {
        width: 10%;
    }
    .col-producto {
        width: 30%;
    }
    .col-cantidad {
        width: 15%;
    }
    .col-total {
        width: 20%;
    }
    .col-hora {
        width: 15%;
    }
</style>
@stop

@section('content')
<div class="container-fluid">
<div class="row mb-3">
        <div class="col-12">
            <h3>Reporte Diario</h3>
            <form method="GET" action="{{ route('reporte.index') }}" class="row">
                <div class="col-md-3">
                    <input type="date" name="fecha" class="form-control" value="{{ request('fecha') ?? date('Y-m-d') }}">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary">Filtrar</button>
                </div>
            </form>
        </div>
    </div>
    <div class="row">
        <!-- Ventas -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <span>Ventas del Día</span>
                    @if(isset($ventas) && $ventas->isNotEmpty())
                    <form action="{{ route('ventas.export-excel') }}" method="POST" class="d-inline">
                        @csrf
                        <input type="hidden" name="fecha" value="{{ request('fecha') }}">
                        <button type="submit" class="btn btn-sm btn-light btn-export">
                            <i class="fas fa-file-excel"></i> Exportar
                        </button>
                    </form>
                    @endif
                </div>
                <div class="card-body p-0">
                    @if(isset($ventas) && $ventas->isNotEmpty())
                        <div class="table-wrapper ventas-table">
                            <table class="table">
                                <thead class="table-header">
                                    <tr>
                                        <th class="col-id">ID</th>
                                        <th class="col-producto">Producto</th>
                                        <th class="col-cantidad">Cantidad</th>
                                        <th class="col-total">Total</th>
                                        <th class="col-hora">Hora</th>
                                    </tr>
                                </thead>
                            </table>
                            <div class="table-container">
                                <table class="table">
                                    <tbody>
                                        @foreach ($ventas as $venta)
                                            <tr>
                                                <td class="col-id">{{ $venta->id }}</td>
                                                <td class="col-producto">{{ Str::limit($venta->producto->nombre, 20) }}</td>
                                                <td class="col-cantidad">{{ $venta->cantidad }}</td>
                                                <td class="col-total">S/ {{ number_format($venta->precio_total, 2) }}</td>
                                                <td class="col-hora">{{ \Carbon\Carbon::parse($venta->created_at)->format('H:i') }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="px-3 py-2 bg-light d-flex justify-content-between align-items-center">
                            <strong>Total:</strong> 
                            <span>S/ {{ number_format($totalVendido, 2) }}</span>
                        </div>
                    @else
                        <div class="p-3 text-muted">No hay ventas</div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Alquileres -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                    <span>Alquileres del Día</span>
                    @if(isset($alquileres) && $alquileres->isNotEmpty())
                    <form action="{{ route('exportar-alquileres-excel') }}" method="POST" class="d-inline">
                        @csrf
                        <input type="hidden" name="fecha" value="{{ request('fecha') }}">
                        <button type="submit" class="btn btn-sm btn-light btn-export">
                            <i class="fas fa-file-excel"></i> Exportar
                        </button>
                    </form>
                    @endif
                </div>
                <div class="card-body p-0">
                    @if(isset($alquileres) && $alquileres->isNotEmpty())
                        <div class="table-wrapper alquileres-table">
                            <table class="table">
                                <thead class="table-header">
                                    <tr>
                                        <th class="col-id">ID</th>
                                        <th class="col-producto">Cliente</th>
                                        <th class="col-cantidad">Horas</th>
                                        <th class="col-total">Total</th>
                                    </tr>
                                </thead>
                            </table>
                            <div class="table-container">
                                <table class="table">
                                    <tbody>
                                        @foreach ($alquileres as $alquiler)
                                            <tr>
                                                <td class="col-id">{{ $alquiler->id }}</td>
                                                <td class="col-producto">{{ Str::limit($alquiler->cliente, 20) }}</td>
                                                <td class="col-cantidad">{{ $alquiler->horas ?? 'N/A' }}</td>
                                                <td class="col-total">S/ {{ number_format($alquiler->precio, 2) }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="px-3 py-2 bg-light d-flex justify-content-between align-items-center">
                            <strong>Total:</strong> 
                            <span>S/ {{ number_format($totalAlquileres, 2) }}</span>
                        </div>
                    @else
                        <div class="p-3 text-muted">No hay alquileres</div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection