@extends('adminlte::page')
@section('title', 'Editar Producto')

<head>
    <link rel="icon" href="{{ asset('icons/producto.png') }}" type="image/x-icon">
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <h2 class="mb-4">Editar Producto</h2>

            @if ($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <form action="{{ route('productos.update', $producto->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="nombre" class="form-label">Nombre del Producto:</label>
                            <input type="text" name="nombre" id="nombre" class="form-control" 
                                   value="{{ old('nombre', $producto->nombre) }}" required>
                        </div>

                        <div class="form-group mb-3">
                            <label for="precio" class="form-label">Precio (S/):</label>
                            <input type="number" name="precio" id="precio" class="form-control" 
                                   step="0.01" value="{{ old('precio', $producto->precio) }}" required>
                        </div>

                        <div class="form-group mb-3">
                            <label for="stock" class="form-label">Stock Disponible:</label>
                            <input type="number" name="stock" id="stock" class="form-control" 
                                   value="{{ old('stock', $producto->stock) }}" required>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label">Imagen Actual:</label>
                            <div class="border p-3 text-center">
                                @if($producto->imagen)
                                    <img src="{{ asset('storage/' . $producto->imagen) }}" 
                                         alt="{{ $producto->nombre }}" 
                                         class="img-fluid mb-2" 
                                         style="max-height: 150px;">
                                    <p class="small text-muted mb-0">Archivo: {{ basename($producto->imagen) }}</p>
                                @else
                                    <p class="text-muted">No hay imagen actual</p>
                                @endif
                            </div>
                        </div>

                        <div class="form-group mb-3">
                            <label for="imagen" class="form-label">Nueva Imagen:</label>
                            <input type="file" name="imagen" id="imagen" class="form-control" 
                                   accept="image/jpeg, image/png, image/jpg">
                            <div class="form-text">Dejar en blanco para mantener la imagen actual</div>
                        </div>

                        @if($producto->imagen)
                        <div class="form-group mb-3 form-check">
                            <input type="checkbox" name="eliminar_imagen" id="eliminar_imagen" 
                                   class="form-check-input">
                            <label for="eliminar_imagen" class="form-check-label">Eliminar imagen actual</label>
                        </div>
                        @endif
                    </div>
                </div>

                <div class="d-flex justify-content-between mt-4">
                    <a href="{{ route('productos.index') }}" class="btn btn-secondary btn-lg">
                        <i class="fas fa-arrow-left"></i> Cancelar
                    </a>
                    <button type="submit" class="btn btn-primary btn-lg">
                        <i class="fas fa-save"></i> Actualizar Producto
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@section('js')
<!-- Bootstrap 5 JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<!-- Script para vista previa de imagen -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Vista previa de la nueva imagen
    const imagenInput = document.getElementById('imagen');
    if (imagenInput) {
        imagenInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(event) {
                    // Crear o actualizar vista previa
                    let previewContainer = document.getElementById('image-preview-container');
                    if (!previewContainer) {
                        previewContainer = document.createElement('div');
                        previewContainer.id = 'image-preview-container';
                        previewContainer.className = 'mt-3 border p-2 text-center';
                        imagenInput.parentNode.appendChild(previewContainer);
                    }
                    
                    previewContainer.innerHTML = `
                        <label class="form-label">Vista previa nueva imagen:</label>
                        <img src="${event.target.result}" class="img-fluid" style="max-height: 150px;">
                    `;
                };
                reader.readAsDataURL(file);
            }
        });
    }
    
    // Manejo del checkbox para eliminar imagen
    const eliminarCheckbox = document.getElementById('eliminar_imagen');
    if (eliminarCheckbox) {
        eliminarCheckbox.addEventListener('change', function() {
            const imagenInput = document.getElementById('imagen');
            if (this.checked) {
                imagenInput.disabled = true;
                imagenInput.value = '';
                // Limpiar vista previa si existe
                const previewContainer = document.getElementById('image-preview-container');
                if (previewContainer) {
                    previewContainer.innerHTML = '';
                }
            } else {
                imagenInput.disabled = false;
            }
        });
    }
});
</script>
@endsection
@endsection