@extends('adminlte::page')

@section('title', 'Editar Categoría')
<head>
    <link rel="icon" href="{{ asset('icons/categoria.png') }}" type="image/x-icon">
</head>
@section('content_header')
    <h1>Editar Categoría</h1>
@endsection

@section('content')
    <form action="{{ route('categorias.update', $categoria) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label for="nombre" class="form-label">Nombre</label>
            <input type="text" name="nombre" class="form-control" value="{{ $categoria->nombre }}" required>
        </div>
        <button type="submit" class="btn btn-primary">Actualizar</button>
        <a href="{{ route('categorias.index') }}" class="btn btn-secondary">Cancelar</a>
    </form>
@endsection
