@extends('adminlte::page')

@section('title', 'Nueva Categoría')
<head>
    <link rel="icon" href="{{ asset('icons/categoria.png') }}" type="image/x-icon">
</head>
@section('content_header')
    <h1 class="text-center text-dark font-weight-bold">Crear Nueva Categoría</h1>
@endsection

@section('content')
<div class="d-flex justify-content-center">
    <div class="card shadow-lg border-0 col-12 col-md-8 col-lg-6 col-xl-4">
        <div class="card-body bg-light p-4 rounded">
            <form action="{{ route('categorias.store') }}" method="POST" class="p-3 border rounded bg-white shadow-sm">
                @csrf
                <div class="form-group">
                    <label class="font-weight-bold">Nombre</label>
                    <input type="text" name="nombre" class="form-control border border-dark rounded p-2 shadow-sm bg-white" required>
                </div>
                <div class="d-flex justify-content-between">
                    <button type="submit" class="btn btn-lg btn-success shadow">Guardar</button>
                    <a href="{{ route('categorias.index') }}" class="btn btn-lg btn-secondary shadow">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
