@extends('adminlte::page')

@section('title', 'Registrar Nuevo Usuario')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card border-0 shadow-lg">
                <div class="card-header bg-gradient-primary text-white rounded-top">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="mb-0"><i class="fas fa-user-plus mr-2"></i>Registrar Nuevo Usuario</h3>
                        <a href="{{ route('usuarios.index') }}" class="btn btn-sm btn-light text-primary">
                            <i class="fas fa-arrow-left mr-1"></i> Volver
                        </a>
                    </div>
                </div>
                
                <div class="card-body p-4">
                    <form method="POST" action="{{ route('register') }}" enctype="multipart/form-data">
                        @csrf
                        
                        @if ($errors->any())
                            <div class="alert alert-danger alert-dismissible fade show">
                                <button type="button" class="close" data-dismiss="alert">&times;</button>
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li><i class="fas fa-exclamation-circle mr-2"></i>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <!-- Foto de Perfil -->
                        <div class="text-center mb-4">
                            <div class="d-inline-block position-relative">
                                <div id="profileImagePreview" class="profile-image-container shadow-sm" 
                                     onclick="document.getElementById('foto').click()">
                                    <i class="fas fa-user default-icon"></i>
                                </div>
                                <label class="btn btn-primary btn-circle profile-image-btn">
                                    <i class="fas fa-camera"></i>
                                    <input type="file" id="foto" name="foto" accept="image/*" class="d-none" onchange="previewProfileImage(this)">
                                </label>
                            </div>
                            <small class="text-muted mt-2 d-block">Formatos: JPG, PNG (Máx. 2MB)</small>
                        </div>

                        <!-- Campos del formulario -->
                        <div class="form-group mb-4">
                            <label for="name" class="form-label"><i class="fas fa-user mr-2 text-primary"></i>Nombre Completo</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text bg-light"><i class="fas fa-user text-primary"></i></span>
                                </div>
                                <input type="text" id="name" name="name" class="form-control" 
                                       value="{{ old('name') }}" required autofocus
                                       placeholder="Ingrese el nombre completo">
                            </div>
                        </div>

                        <div class="form-group mb-4">
                            <label for="email" class="form-label"><i class="fas fa-envelope mr-2 text-primary"></i>Correo Electrónico</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text bg-light"><i class="fas fa-at text-primary"></i></span>
                                </div>
                                <input type="email" id="email" name="email" class="form-control" 
                                       value="{{ old('email') }}" required
                                       placeholder="Ingrese el correo electrónico">
                            </div>
                        </div>

                        <div class="form-group mb-4">
                            <label for="password" class="form-label"><i class="fas fa-lock mr-2 text-primary"></i>Contraseña</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text bg-light"><i class="fas fa-key text-primary"></i></span>
                                </div>
                                <input type="password" id="password" name="password" class="form-control" 
                                       required placeholder="Mínimo 8 caracteres">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary toggle-password" type="button">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mb-4">
                            <label for="password_confirmation" class="form-label"><i class="fas fa-lock mr-2 text-primary"></i>Confirmar Contraseña</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text bg-light"><i class="fas fa-key text-primary"></i></span>
                                </div>
                                <input type="password" id="password_confirmation" name="password_confirmation" 
                                       class="form-control" required placeholder="Repita la contraseña">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary toggle-password" type="button">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Selección de Rol -->
                        <div class="form-group mb-4">
                            <label for="role" class="form-label"><i class="fas fa-cogs mr-2 text-primary"></i>Rol</label>
                            <select id="role" name="role" class="form-control" required>
                                <option value="super-admin" {{ old('role') == 'super-admin' ? 'selected' : '' }}>Super Admin</option>
                                <option value="personal" {{ old('role') == 'personal' ? 'selected' : '' }}>Personal</option>
                            </select>
                        </div>

                        <div class="form-group text-center mt-4">
                            <button type="submit" class="btn btn-primary btn-lg px-5 shadow">
                                <i class="fas fa-user-plus mr-2"></i>Registrar Usuario
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('css')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
    /* Estilos de la tarjeta, imagen de perfil, etc. */
</style>
@endsection

@section('js')
<script>
    // Vista previa de la imagen de perfil
    function previewProfileImage(input) {
        const preview = document.getElementById('profileImagePreview');
        const file = input.files[0];
        const reader = new FileReader();
        
        if (file) {
            // Validar tamaño máximo (2MB)
            if (file.size > 2 * 1024 * 1024) {
                alert('La imagen no debe exceder los 2MB');
                input.value = '';
                return;
            }
            
            reader.onload = function(e) {
                if (preview.tagName === 'IMG') {
                    preview.src = e.target.result;
                } else {
                    // Si es el placeholder, lo reemplazamos con una imagen
                    const newPreview = document.createElement('img');
                    newPreview.id = 'profileImagePreview';
                    newPreview.src = e.target.result;
                    newPreview.className = 'profile-image-container shadow-sm';
                    newPreview.style.objectFit = 'cover';
                    newPreview.onclick = function() {
                        document.getElementById('foto').click();
                    };
                    preview.parentNode.replaceChild(newPreview, preview);
                }
            }
            reader.readAsDataURL(file);
        }
    }

    // Mostrar/ocultar contraseña
    document.querySelectorAll('.toggle-password').forEach(function(button) {
        button.addEventListener('click', function() {
            const input = this.closest('.input-group').querySelector('input');
            const icon = this.querySelector('i');
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        });
    });
</script>
@endsection
