@extends('adminlte::page')

@section('title', 'Detalles del Alquiler')

<head>
    <link rel="icon" href="{{ asset('icons/servicio.png') }}" type="image/x-icon">
</head>

@section('content_header')
    <h1>Detalles del Alquiler</h1>
@endsection

@section('content')
    <div class="card shadow-lg rounded">
        <div class="card-header">
            <h3 class="card-title">Información Completa del Alquiler</h3>
        </div>
        <div class="card-body">
           

            <!-- Información Detallada del Alquiler -->
            <div class="table-responsive mt-4">
                <table class="table table-striped table-bordered table-hover">
                    <tbody>
                        <tr>
                            <th class="text-nowrap">Película</th>
                            <td>{{ $alquiler->pelicula?->titulo ?? 'Película no encontrada' }}</td>
                        </tr>
                        <tr>
                            <th class="text-nowrap">Cliente</th>
                            <td>{{ $alquiler->cliente }}</td>
                        </tr>
                        <tr>
                            <th class="text-nowrap">Sala</th>
                            <td>{{ $alquiler->sala?->nombre ?? 'Sala no encontrada' }}</td>
                        </tr>
                        <tr>
                            <th class="text-nowrap">Hora de Inicio</th>
                            <td>{{ $alquiler->hora_entrada }}</td>
                        </tr>
                        <tr>
                            <th class="text-nowrap">Hora de Fin</th>
                            <td>{{ $alquiler->hora_salida }}</td>
                        </tr>
                        
                        <tr>
                            <th class="text-nowrap">Estado</th>
                            <td>{{ $alquiler->estado }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <a href="{{ route('alquileres.index') }}" class="btn btn-outline-primary mt-3">Volver</a>
        </div>
    </div>
@endsection
