@extends('adminlte::page')
@section('title', 'Crear Alquiler')

<head>
    <link rel="icon" href="{{ asset('imagenes/servicio.png') }}" type="image/x-icon">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        .card-form {
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            border: none;
        }
        .card-header {
            border-radius: 10px 10px 0 0 !important;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .form-control, .select2-container--default .select2-selection--single {
            border-radius: 8px;
            height: calc(2.25rem + 8px);
            border: 1px solid #e0e0e0;
        }
        .input-group-text {
            border-radius: 8px 0 0 8px;
            background-color: #f8f9fa;
        }
        .btn-primary {
            background-color: #667eea;
            border-color: #667eea;
        }
        .btn-primary:hover {
            background-color: #5a6fd1;
            border-color: #5a6fd1;
        }
        .search-results {
            position: absolute;
            z-index: 1000;
            width: 100%;
            max-height: 200px;
            overflow-y: auto;
            border: 1px solid #e0e0e0;
            border-radius: 0 0 8px 8px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .search-results a {
            transition: all 0.2s;
        }
        .search-results a:hover {
            background-color: #f8f9fa;
        }
        .alert {
            border-radius: 8px;
        }
        .btn-search {
            border-radius: 0 8px 8px 0;
        }
        .min-vh-80 {
            min-height: 80vh;
        }
    </style>
</head>

@section('content_header')
<div class="d-flex justify-content-center w-100 flex-wrap">
    <div class="card-tools"></div>
</div>
@stop

@section('content')
<div class="d-flex justify-content-center align-items-center min-vh-80 py-4">
    <div class="container">
        <!-- Tarjeta de búsqueda de DNI -->
        <div class="row justify-content-center mb-4">
            <div class="col-md-8 col-lg-6">
                <div class="card card-form">
                    <div class="card-body p-4">
                        <h5 class="card-title text-center mb-3 text-primary">
                            <i class="fas fa-id-card mr-2"></i>Buscar Cliente por DNI
                        </h5>
                        <form action="{{ route('dni.search') }}" method="POST" class="d-flex justify-content-center">
                            @csrf
                            <div class="input-group" style="max-width: 400px;">
                                <input type="text" class="form-control text-center fw-bold" id="dni" name="dni" 
                                       placeholder="Ingrese DNI" maxlength="8" required 
                                       style="height: 45px; font-size: 1rem;">
                                <button type="submit" class="btn btn-primary btn-search" style="height: 45px;">
                                    <i class="fas fa-search mr-1"></i> Buscar
                                </button>
                            </div>
                        </form>
                        
                        @if(isset($data) && $data['estado'] && isset($data['resultado']['nombre_completo']))
                            <div class="mt-3 alert alert-success text-center">
                                <i class="fas fa-check-circle mr-2"></i>
                                <strong>Cliente encontrado:</strong> {{ $data['resultado']['nombre_completo'] }}
                            </div>
                        @elseif(isset($data) && !$data['estado'])
                            <div class="mt-3 alert alert-danger text-center">
                                <i class="fas fa-exclamation-circle mr-2"></i>
                                <strong>Error:</strong> No se encontró ningún resultado para el DNI ingresado.
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Formulario de Alquiler -->
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card card-form">
                    <div class="card-header text-white">
                        <h3 class="card-title text-center mb-0">
                            <i class="fas fa-film mr-2"></i>Registrar Nuevo Alquiler
                        </h3>
                    </div>
                    <div class="card-body p-4">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <h5 class="alert-heading">
                                    <i class="fas fa-exclamation-triangle mr-2"></i>Error en el formulario
                                </h5>
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <form id="alquiler-form" action="{{ route('alquileres.store') }}" method="POST">
                            @csrf
                            
                            <!-- Búsqueda de Película -->
                            <div class="form-group mb-4">
                                <label for="pelicula_search" class="font-weight-bold text-primary">
                                    <i class="fas fa-video mr-2"></i>Película
                                </label>
                                <div class="position-relative">
                                    <div class="input-group">
                                        <input type="text" id="pelicula_search" class="form-control" 
                                               placeholder="Buscar película por nombre..." autocomplete="off" required>
                                        <div class="input-group-append">
                                            <button class="btn btn-outline-secondary" type="button" id="search-btn">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div id="search-results" class="search-results list-group" style="display: none;"></div>
                                </div>
                                <input type="hidden" name="pelicula_id" id="pelicula_id">
                                <input type="hidden" id="duracion_pelicula">
                            </div>

                            <!-- Selección de Sala -->
                            @if(isset($salas) && count($salas) > 0)
                                <div class="form-group mb-4">
                                    <label for="sala_id" class="font-weight-bold text-primary">
                                        <i class="fas fa-door-open mr-2"></i>Sala
                                    </label>
                                    <select name="sala_id" id="sala_id" class="form-control select2" required>
                                        <option value="" disabled selected>Seleccione una sala</option>
                                        @foreach ($salas as $sala)
                                            <option value="{{ $sala->id }}" {{ old('sala_id') == $sala->id ? 'selected' : '' }}>
                                                {{ $sala->nombre }} ({{ $sala->tipo }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            @else
                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle mr-2"></i>No hay salas disponibles.
                                </div>
                            @endif

                            <!-- Datos del Cliente -->
                            <div class="form-group mb-4">
                                <label for="cliente" class="font-weight-bold text-primary">
                                    <i class="fas fa-user mr-2"></i>Cliente
                                </label>
                                <input type="text" class="form-control" id="cliente" name="cliente" 
                                       placeholder="Nombre completo del cliente" 
                                       value="{{ isset($data) && isset($data['resultado']['nombre_completo']) ? $data['resultado']['nombre_completo'] : old('cliente') }}"
                                       required>
                            </div>

                            <!-- Horario -->
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group mb-4">
                                        <label for="hora_entrada" class="font-weight-bold text-primary">
                                            <i class="fas fa-clock mr-2"></i>Hora de Entrada
                                        </label>
                                        <input type="time" name="hora_entrada" id="hora_entrada" 
                                               class="form-control" value="{{ old('hora_entrada') }}" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group mb-4">
                                        <label for="hora_salida" class="font-weight-bold text-primary">
                                            <i class="fas fa-clock mr-2"></i>Hora de Salida (Calculada)
                                        </label>
                                        <input type="time" name="hora_salida" id="hora_salida" 
                                               class="form-control" value="{{ old('hora_salida') }}" readonly>
                                    </div>
                                </div>
                            </div>

                            <!-- Precio -->
                            <div class="form-group mb-4">
                                <label for="precio" class="font-weight-bold text-primary">
                                    <i class="fas fa-money-bill-wave mr-2"></i>Precio (S/)
                                </label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">S/</span>
                                    </div>
                                    <input type="number" name="precio" id="precio" class="form-control" 
                                           step="0.01" min="0" placeholder="0.00" required>
                                </div>
                            </div>

                            <!-- Botones de acción -->
                            <div class="d-flex justify-content-between mt-4">
                                <button type="submit" class="btn btn-success btn-lg px-4" id="btn-submit">
                                    <i class="fas fa-save mr-2"></i> Guardar
                                </button>
                                <a href="{{ route('alquileres.index') }}" class="btn btn-secondary btn-lg px-4">
                                    <i class="fas fa-times mr-2"></i> Cancelar
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Inicializar Select2
            $('.select2').select2({
                placeholder: "Seleccione una sala",
                allowClear: true
            });

            // Función para buscar películas
            $('#pelicula_search').on('keyup', function() {
                var searchTerm = $(this).val();
                $('#search-results').hide();

                if (searchTerm.length > 2) {
                    $.ajax({
                        url: '{{ route('peliculas.search') }}',
                        method: 'GET',
                        data: { term: searchTerm },
                        success: function(response) {
                            $('#search-results').empty();

                            if(response.peliculas.length > 0) {
                                response.peliculas.forEach(function(pelicula) {
                                    $('#search-results').append(
                                        '<a href="#" class="list-group-item list-group-item-action" ' +
                                        'data-id="' + pelicula.id + '" ' +
                                        'data-title="' + pelicula.titulo + '" ' +
                                        'data-duracion="' + pelicula.duracion + '">' +
                                        '<div class="d-flex align-items-center">' +
                                        (pelicula.imagen ? '<img src="/storage/' + pelicula.imagen + '" class="rounded mr-3" width="40" height="60" style="object-fit: cover;">' : '') +
                                        '<div>' +
                                        '<h6 class="mb-1">' + pelicula.titulo + '</h6>' +
                                        '<small class="text-muted">Duración: ' + pelicula.duracion + ' min</small>' +
                                        '</div></div></a>'
                                    );
                                });
                                $('#search-results').show();
                            }
                        },
                        error: function() {
                            console.error('Error al buscar películas');
                        }
                    });
                }
            });

            // Seleccionar una película
            $('#search-results').on('click', 'a', function(e) {
                e.preventDefault();
                var id = $(this).data('id');
                var title = $(this).data('title');
                var duracion = $(this).data('duracion');
                
                $('#pelicula_search').val(title);
                $('#pelicula_id').val(id);
                $('#duracion_pelicula').val(duracion);
                $('#search-results').hide();
                
                // Calcular hora de salida si ya hay hora de entrada
                if ($('#hora_entrada').val()) {
                    calcularHoraSalida();
                }
            });

            // Cuando cambia la hora de entrada
            $('#hora_entrada').on('change', function() {
                if ($('#duracion_pelicula').val()) {
                    calcularHoraSalida();
                }
            });

            // Función para calcular hora de salida
            function calcularHoraSalida() {
                var horaEntrada = $('#hora_entrada').val();
                var duracion = $('#duracion_pelicula').val();
                
                if (!horaEntrada || !duracion) return;
                
                // Convertir hora de entrada a minutos desde medianoche
                var partesHora = horaEntrada.split(':');
                var horas = parseInt(partesHora[0]);
                var minutos = parseInt(partesHora[1]);
                var totalMinutos = horas * 60 + minutos;
                
                // Sumar la duración de la película (asumiendo que está en minutos)
                totalMinutos += parseInt(duracion);
                
                // Convertir de vuelta a formato HH:MM
                var horasSalida = Math.floor(totalMinutos / 60) % 24;
                var minutosSalida = totalMinutos % 60;
                
                // Formatear con ceros a la izquierda
                var horaSalida = 
                    (horasSalida < 10 ? '0' + horasSalida : horasSalida) + ':' + 
                    (minutosSalida < 10 ? '0' + minutosSalida : minutosSalida);
                
                $('#hora_salida').val(horaSalida);
            }

            // Cerrar resultados al hacer clic fuera
            $(document).on('click', function(e) {
                if (!$(e.target).closest('#pelicula_search, #search-results').length) {
                    $('#search-results').hide();
                }
            });

            // Validación de horas
            $('#alquiler-form').submit(function(e) {
                e.preventDefault();
                
                var horaEntrada = $('#hora_entrada').val();
                var horaSalida = $('#hora_salida').val();

                if (horaSalida <= horaEntrada) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error en horario',
                        text: 'La hora de salida debe ser posterior a la hora de entrada',
                        confirmButtonText: 'Entendido'
                    });
                } else {
                    Swal.fire({
                        title: '¿Confirmar alquiler?',
                        html: '<div class="text-center">' +
                              '<i class="fas fa-film fa-3x text-primary mb-3"></i>' +
                              '<p>¿Está seguro de registrar este alquiler?</p>' +
                              '</div>',
                        showCancelButton: true,
                        confirmButtonColor: '#667eea',
                        cancelButtonColor: '#d33',
                        confirmButtonText: '<i class="fas fa-check mr-2"></i> Sí, registrar',
                        cancelButtonText: '<i class="fas fa-times mr-2"></i> Cancelar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            this.submit();
                        }
                    });
                }
            });

            // Búsqueda de DNI
            $('#dni').on('input', function() {
                this.value = this.value.replace(/[^0-9]/g, '');
            });
        });
    </script>
@endsection