<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('ventas', function (Blueprint $table) {
            $table->foreignId('alquiler_id')->nullable()->constrained('alquileres')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('ventas', function (Blueprint $table) {
            $table->dropForeign(['alquiler_id']);
            $table->dropColumn('alquiler_id');
        });
    }
};