<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('peliculas', function (Blueprint $table) {
            $table->id();
            $table->string('titulo');
            $table->integer('duracion'); // En minutos
            $table->string('formato'); // DVD o Blu-ray
            $table->unsignedBigInteger('categoria_id'); // Asegurar compatibilidad con 'id' de 'categorias'
            $table->enum('estado', ['disponible', 'alquilada'])->default('disponible');
            $table->timestamps();

            // Clave foránea correctamente definida
            $table->foreign('categoria_id')->references('id')->on('categorias')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('peliculas');
    }
};
