<?php

namespace App\Http\Controllers;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use App\Models\Sala;
use Illuminate\Pagination\Paginator;

class SalaController extends Controller
{
    public function index()
    {
        $salas = Sala::paginate(9); // Cambiado de all() a paginate(10)
        return view('salas.index', compact('salas'));
    }

    public function create()
    {
        return view('salas.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nombre' => 'required|string|max:255',
            'capacidad' => 'required|integer|min:1',
            'tipo' => 'required|in:Normal,VIP',
            'estado' => 'required|in:Disponible,Ocupado,Mantenimiento'
        ]);
    
        Sala::create($request->all());
    
        return redirect()->route('salas.index')->with('success', 'Sala creada con éxito.');
    }
    
    public function show(Sala $sala)
    {
        return view('salas.show', compact('sala'));
    }

    public function edit(Sala $sala)
    {
        return view('salas.edit', compact('sala'));
    }

    public function update(Request $request, Sala $sala)
    {
        $request->validate([
            'nombre' => 'required|string|max:255',
            'capacidad' => 'required|integer|min:1',
            'tipo' => 'required|in:VIP,Normal' // Asegura que solo acepte valores válidos
        ]);

        $sala->update($request->all());

        return redirect()->route('salas.index')
                         ->with('success', 'Sala actualizada con éxito.');
    }

    public function destroy(Sala $sala)
    {
        $sala->delete();

        return redirect()->route('salas.index')
                         ->with('success', 'Sala eliminada con éxito.');
    }
    public function boot()
{
    Paginator::useBootstrapFive();
}

public function exportToPDF()
{
    $salas = Sala::all(); // Obtiene todas las salas
    $pdf = Pdf::loadView('salas.pdf', compact('salas'));

    return $pdf->stream('salas.pdf'); // Muestra el PDF en el navegador
    // return $pdf->download('salas.pdf'); // Opción para descargar directamente
}

}